/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.ItemType;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.ItemDescriptor;
import cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.pogamut.udk.communication.translator.shared.events.ItemDescriptorObtained;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ItemDescriptors
extends SensorModule<UDKBot> {
    private Map<String, ItemDescriptor> inventoryTypeDescs = new HashMap<String, ItemDescriptor>();
    private Map<ItemType, ItemDescriptor> descs = new HashMap<ItemType, ItemDescriptor>();
    private HashMap<ItemType, ItemType> ammoToWeapon = new HashMap();
    private ItemDescriptorObtainedListener itemDescObtainedListener;

    public ItemType getWeaponForAmmo(ItemType ammoType) {
        return this.ammoToWeapon.get(ammoType);
    }

    public boolean hasDescriptor(ItemType itemType) {
        return this.descs.containsKey(itemType);
    }

    public ItemDescriptor getDescriptor(ItemType itemType) {
        return this.descs.get(itemType);
    }

    public boolean hasDescriptor(String inventoryType) {
        return this.inventoryTypeDescs.containsKey(inventoryType);
    }

    public ItemDescriptor getDescriptor(String inventoryType) {
        return this.inventoryTypeDescs.get(inventoryType);
    }

    protected void start(boolean startPaused) {
        super.start(startPaused);
        this.inventoryTypeDescs.clear();
        this.descs.clear();
    }

    public ItemDescriptors(UDKBot bot) {
        this(bot, null);
    }

    public ItemDescriptors(UDKBot bot, LogCategory moduleLog) {
        super((IObservingAgent)bot, (Logger)moduleLog);
        this.itemDescObtainedListener = new ItemDescriptorObtainedListener((IWorldView)bot.getWorldView());
    }

    private class ItemDescriptorObtainedListener
    implements IWorldEventListener<ItemDescriptorObtained> {
        private IWorldView worldView;

        public ItemDescriptorObtainedListener(IWorldView worldView) {
            worldView.addEventListener(ItemDescriptorObtained.class, (IWorldEventListener)this);
            this.worldView = worldView;
        }

        public void notify(ItemDescriptorObtained event) {
            ItemDescriptors.this.inventoryTypeDescs.put(event.getItemDescriptor().getInventoryType(), event.getItemDescriptor());
            ItemDescriptors.this.descs.put(event.getItemDescriptor().getPickupType(), event.getItemDescriptor());
            if (event.getItemDescriptor() instanceof WeaponDescriptor) {
                WeaponDescriptor desc = (WeaponDescriptor)event.getItemDescriptor();
                if (desc.getPriAmmoItemType() != null) {
                    ItemDescriptors.this.ammoToWeapon.put(desc.getPriAmmoItemType(), desc.getPickupType());
                }
                if (desc.getSecAmmoItemType() != null) {
                    ItemDescriptors.this.ammoToWeapon.put(desc.getSecAmmoItemType(), desc.getPickupType());
                }
            }
        }
    }
}

