/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.udk.agent.module.logic.UDKBotLogic;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.EndMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncUDKBotLogic<BOT extends UDKBot<? extends ILockableVisionWorldView, ?, ?>>
extends UDKBotLogic<BOT> {
    private EventReact<EndMessage> endReactionAfterRespawn;
    private int shouldExecuteLogicLatch = 0;
    private ICommandListener<Respawn> respawnListener = new ICommandListener<Respawn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(Respawn event) {
            ICommandListener iCommandListener = SyncUDKBotLogic.this.respawnListener;
            synchronized (iCommandListener) {
                SyncUDKBotLogic.this.endReactionAfterRespawn.enable();
                SyncUDKBotLogic.this.shouldExecuteLogicLatch = 2;
            }
        }
    };

    @Inject
    public SyncUDKBotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(((UDKBot)agent).getWorldView()));
    }

    public SyncUDKBotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(((UDKBot)agent).getWorldView()));
    }

    public SyncUDKBotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.endReactionAfterRespawn = new EventReact<EndMessage>(EndMessage.class, ((UDKBot)agent).getWorldView()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void react(EndMessage event) {
                ICommandListener iCommandListener = SyncUDKBotLogic.this.respawnListener;
                synchronized (iCommandListener) {
                    if (SyncUDKBotLogic.this.shouldExecuteLogicLatch > 0) {
                        --SyncUDKBotLogic.this.shouldExecuteLogicLatch;
                    }
                }
            }
        };
        agent.getAct().addCommandListener(Respawn.class, this.respawnListener);
    }

    protected void beforeLogic(String threadName) {
        super.beforeLogic(threadName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(threadName + ": Locking world view.");
        }
        ((ILockableVisionWorldView)((UDKBot)this.agent).getWorldView()).lock();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(threadName + ": World view locked.");
        }
    }

    protected void afterLogic(String threadName) {
        super.afterLogic(threadName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(threadName + ": Unlocking world view.");
        }
        ((ILockableVisionWorldView)((UDKBot)this.agent).getWorldView()).unlock();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(threadName + ": World view unlocked.");
        }
    }

    protected void afterLogicException(String threadName, Throwable e) {
        super.afterLogicException(threadName, e);
        if (((ILockableVisionWorldView)((UDKBot)this.agent).getWorldView()).isLocked()) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Unlocking world view.");
            }
            ((ILockableVisionWorldView)((UDKBot)this.agent).getWorldView()).unlock();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view unlocked.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldExecuteLogic() {
        ICommandListener<Respawn> iCommandListener = this.respawnListener;
        synchronized (iCommandListener) {
            if (this.shouldExecuteLogicLatch != 0) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Respawn command sensed - waiting for the bot respawn to execute logic with correct world view state.");
                }
                return false;
            }
            return true;
        }
    }
}

