package cz.cuni.amis.pogamut.udk.communication.translator.itemdescriptor;

import cz.cuni.amis.pogamut.udk.communication.messages.ItemType;

/**
 * A shield factory takes care about all items which fall into a {@link ItemType.Category#SHIELD}.
 *
 * @author Jimmy
 */
public class ShieldDescriptorFactory implements IDescriptorFactory<ShieldDescriptor> {

    private static ShieldDescriptorFactory instance = new ShieldDescriptorFactory();

    private ShieldDescriptorFactory() {
    }

    public static ShieldDescriptorFactory getInstance() {
        return instance;
    }

    public ShieldDescriptor getNewDescriptor(ItemTyped configMsg) {
        ShieldDescriptor desc = new ShieldDescriptor();
        desc.doReflexion(configMsg, ShieldDescriptor.class);
        return desc;
    }
}