/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.storyworld.place;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.cuni.amis.pogamut.udk.storyworld.place.SPStoryPlace;
import cz.cuni.amis.pogamut.udk.storyworld.place.SPStoryPlaceBase;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@XStreamAlias(value="storyworld")
public class SPStoryWorldData {
    @XStreamAlias(value="places")
    private List<SPStoryPlace> places;
    @XStreamAlias(value="bases")
    private List<SPStoryPlaceBase> bases;
    @XStreamOmitField
    private Map<Token, SPStoryPlace> placesMap;
    @XStreamOmitField
    private Map<Token, SPStoryPlaceBase> basesMap;
    @XStreamOmitField
    private String file = "<generated in code>";

    public SPStoryWorldData() {
    }

    public static SPStoryWorldData loadXML(File xmlFile) throws FileNotFoundException {
        FileReader reader = new FileReader(xmlFile);
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.autodetectAnnotations(true);
        xstream.alias(SPStoryWorldData.class.getAnnotation(XStreamAlias.class).value(), SPStoryWorldData.class);
        Object obj = xstream.fromXML((Reader)reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!(obj instanceof SPStoryWorldData)) {
            throw new RuntimeException("file " + xmlFile.getAbsolutePath() + " doesn't contain a xml with SPStoryWorldData");
        }
        SPStoryWorldData data = (SPStoryWorldData)obj;
        data.file = xmlFile.getAbsolutePath();
        return data;
    }

    public SPStoryWorldData(SPStoryPlace[] places, SPStoryPlaceBase[] bases) {
        this.places = MyCollections.asList((Object[])places);
        this.bases = MyCollections.asList((Object[])bases);
        this.readResolve();
    }

    private SPStoryWorldData readResolve() {
        SPStoryPlace inside;
        this.placesMap = new HashMap<Token, SPStoryPlace>();
        this.basesMap = new HashMap<Token, SPStoryPlaceBase>();
        for (SPStoryPlace place : this.places) {
            this.placesMap.put(place.getName(), place);
        }
        for (SPStoryPlaceBase base : this.bases) {
            this.basesMap.put(base.getName(), base);
        }
        for (SPStoryPlace place : this.places) {
            if (place.getInsidePlaceName() == null) continue;
            inside = this.placesMap.get(Tokens.get((String)place.getInsidePlaceName()));
            if (inside == null) {
                String notice = this.basesMap.get(Tokens.get((String)place.getInsidePlaceName())) != null ? " Notice that provided name points to the /base/ not /place/, but /base/ places can't contain any other places!" : "";
                throw new RuntimeException("story place '" + place.getName().getToken() + "' reference unknown place '" + place.getInsidePlaceName() + "'" + notice);
            }
            place.setInsidePlace(inside);
        }
        for (SPStoryPlaceBase base : this.bases) {
            this.basesMap.put(base.getName(), base);
        }
        for (SPStoryPlaceBase base : this.bases) {
            if (base.getInsidePlaceName() == null) continue;
            inside = this.placesMap.get(Tokens.get((String)base.getInsidePlaceName()));
            if (inside == null) {
                String notice = this.basesMap.get(Tokens.get((String)base.getInsidePlaceName())) != null ? " Notice that provided name points to the /base/ not /place/, but /base/ places can't contain any other places!" : "";
                throw new RuntimeException("story place '" + base.getName().getToken() + "' reference unknown place '" + base.getInsidePlaceName() + "'" + notice);
            }
            base.setInsidePlace(inside);
        }
        return this;
    }

    public Map<Token, SPStoryPlace> getPlaces() {
        return this.placesMap;
    }

    public Map<Token, SPStoryPlaceBase> getBases() {
        return this.basesMap;
    }

    public String getFile() {
        return this.file;
    }

    public String toString() {
        return "SPStoryWorldData[places=" + this.places.size() + ", bases=" + this.bases.size() + "]";
    }
}

