/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorHelper;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.udk.agent.navigation.IUDKPathNavigator;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class AbstractUDKPathNavigator<PATH_ELEMENT extends ILocated>
implements IUDKPathNavigator<PATH_ELEMENT> {
    protected UDKBot bot;
    protected IPathExecutorHelper<PATH_ELEMENT> executor;
    protected Self self;

    @Override
    public void setBot(UDKBot bot) {
        this.bot = bot;
    }

    @Override
    public void setExecutor(IPathExecutorHelper<PATH_ELEMENT> owner) {
        this.executor = owner;
    }

    @Override
    public void navigate() {
        if (this.bot == null) {
            throw new PogamutException("The 'bot' field is null (or was not set by the executor), can't navigate.", (Object)this);
        }
        if (this.executor == null) {
            throw new PogamutException("The 'executor' field is null (ow was not set by the executor), can't navigate.", (Object)this);
        }
        int pathElementIndex = this.executor.getPathElementIndex();
        if (pathElementIndex < 0 || pathElementIndex >= this.executor.getPath().size()) {
            throw new PogamutException("Can't navigate as the current path element index is out of path range (index = " + pathElementIndex + ", path.size() = " + this.executor.getPath().size() + ".", (Object)this);
        }
        if (this.self == null) {
            this.self = (Self)this.bot.getWorldView().getSingle(Self.class);
            if (this.self == null) {
                throw new PogamutException("Can't navigate the bot, no Self instance is available in the world view.", (Object)this);
            }
        }
        this.navigate(pathElementIndex);
    }

    protected abstract void navigate(int var1);
}

