/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.experiments.utils;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateResumed;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateStartedPaused;
import cz.cuni.amis.pogamut.udk.experiments.utils.IWatchAgentCallback;
import cz.cuni.amis.utils.flag.FlagListener;

public class WatchAgent {
    private IAgent agent;
    private IAgentState lastState;
    private boolean isWatching = false;
    private IWatchAgentCallback callback;
    private FlagListener<IAgentState> listener = new FlagListener<IAgentState>(){

        public void flagChanged(IAgentState state) {
            if (state instanceof IAgentStateStartedPaused) {
                if (!(WatchAgent.this.lastState instanceof IAgentStateStartedPaused)) {
                    WatchAgent.this.callback.agentStartedPaused(WatchAgent.this.agent);
                }
            } else if (state instanceof IAgentStateRunning && !(WatchAgent.this.lastState instanceof IAgentStateRunning)) {
                WatchAgent.this.callback.agentStarted(WatchAgent.this.agent);
            }
            if (state instanceof IAgentStateResumed && !(WatchAgent.this.lastState instanceof IAgentStateResumed)) {
                WatchAgent.this.callback.agentResumed(WatchAgent.this.agent);
            }
            if (state instanceof IAgentStateStopped && !(WatchAgent.this.lastState instanceof IAgentStateStopped)) {
                WatchAgent.this.callback.agentStopped(WatchAgent.this.agent);
            }
            if (state instanceof IAgentStateFailed && !(WatchAgent.this.lastState instanceof IAgentStateFailed)) {
                WatchAgent.this.callback.agentKilled(WatchAgent.this.agent);
            }
            WatchAgent.this.lastState = state;
        }
    };

    public WatchAgent(IAgent agent, IWatchAgentCallback callback) {
        this.agent = agent;
        this.lastState = (IAgentState)agent.getState().getFlag();
        this.callback = callback;
    }

    public synchronized void startWatching() {
        if (this.isWatching) {
            return;
        }
        this.agent.getState().addListener(this.listener);
        this.isWatching = true;
    }

    public synchronized void stopWatching() {
        if (!this.isWatching) {
            return;
        }
        this.agent.getState().removeListener(this.listener);
        this.isWatching = false;
    }
}

