/*
 * Copyright (C) 2011 AMIS research group, Faculty of Mathematics and Physics, Charles University in Prague, Czech Republic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.cuni.amis.pogamut.udk.experiments;


import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.udk.server.IUDKServer;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper;
import cz.cuni.amis.pogamut.udk.utils.UCCWrapper.UCCWrapperConf;
import cz.cuni.amis.utils.flag.Flag;
/**
 *
 * @author Martin Cerny
 */
public interface IExperiment<RESULT, PARAMETERS> {
    
    void setLog(LogCategory log);
    
    /**
     * Do some processing, before the server is started
     */
    void beforeServerStart();
    
    /**
     * Get the configuration for the UDK server.
     * @return 
     */
    UCCWrapperConf getUCCWrapperConfiguration();
       
    /**
     * Do some processing after the server has started
     * @param ucc
     * @param server 
     */
    void serverStarted(UCCWrapper ucc, IUDKServer server);
    
    /**
     * Start the experiment (ie. run bots, setup observers, ...)
     */
    void startExperiment();
    
    /**
     * <p>Cleanup after the experiment. Is called whenever the experiment ends due to:
     * </p>     
     * <ol>
     * <li>finished flag is set to true
     * </li>
     * <li>any method of this class throws an exception
     * </li>
     * <li>the server fails to start
     * </li>
     * </ol>
     * The cleanup method should release all resources already allocated and should
     * not fail in any of the cases mentioned above.
     */
    void cleanup();
    
    Flag<Boolean> getFinished();
    
    boolean isSuccess();
    
    RESULT getResult();
    
    PARAMETERS getParameters();
    /**
     * Short description of the experiment for loggin purposes
     * @return 
     */
    public String getDescription();
}
