/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.api.pogamut.ut2004.server;

import cz.cuni.amis.nb.api.pogamut.ut2004.server.UTServerDefinition;
import cz.cuni.amis.nb.pogamut.base.server.ServerNode;
import cz.cuni.amis.nb.pogamut.ut2004.server.UTEmbededServerNode;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.utils.flag.Flag;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class EmbeddedUTServerDefinition
extends UTServerDefinition {
    Flag<String> serverHomePath = new Flag();
    Flag<String> serverExec = new Flag();
    transient UCCWrapper uccWrapper = null;
    transient Logger log = null;

    public Flag<String> getServerHomePathFlag() {
        return this.serverHomePath;
    }

    public Flag<String> getServerExecFlag() {
        return this.serverExec;
    }

    @Override
    public ServerNode getViewer() {
        return new UTEmbededServerNode<EmbeddedUTServerDefinition>(this);
    }

    public void startEmbeddedServer() throws UCCStartException {
        if (this.uccWrapper == null) {
            UCCWrapperConf conf = new UCCWrapperConf();
            this.log = Logger.getAnonymousLogger();
            conf.setLogger(this.log);
            final InputOutput io = IOProvider.getDefault().getIO("UCC " + this.getServerName(), false);
            io.select();
            this.log.addHandler(new Handler(){

                @Override
                public void publish(LogRecord record) {
                    io.getOut().println(record.getMessage());
                }

                @Override
                public void flush() {
                    io.getOut().flush();
                }

                @Override
                public void close() throws SecurityException {
                    io.closeInputOutput();
                }
            });
            this.uccWrapper = new UCCWrapper(conf);
        }
    }

    public void stopEmbeddedServer() {
        this.uccWrapper.stop();
        this.uccWrapper = null;
    }
}

