/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.nb.pogamut.options;

import java.awt.Color;
import java.util.prefs.Preferences;
import javax.swing.JColorChooser;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/**
 * Secondary option panel for options of timeline and map.
 * For now settings consists from flags, see {{@link MapFlag}} for details and
 * colors used in map, see {{@link MapColor}} for details.
 * See tutorial at http://platform.netbeans.org/tutorials/nbm-options.html
 * 
 * @author Honza
 */
final public class TimelinePanel extends javax.swing.JPanel {

    private final TimelineOptionsPanelController controller;

    TimelinePanel(TimelineOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        // TODO listen to changes in form fields and call controller.changed()
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        FlagsBehaviorRadioGroup = new javax.swing.ButtonGroup();
        mapFlagsPanel = new javax.swing.JPanel();
        walkFlagCheckBox = new javax.swing.JCheckBox();
        flyFlagCheckBox = new javax.swing.JCheckBox();
        swimFlagCheckBox = new javax.swing.JCheckBox();
        jumpFlagCheckBox = new javax.swing.JCheckBox();
        doorFlagCheckBox = new javax.swing.JCheckBox();
        specialFlagCheckBox = new javax.swing.JCheckBox();
        ladderFlagCheckBox = new javax.swing.JCheckBox();
        proscribedFlagCheckBox = new javax.swing.JCheckBox();
        forcedFlagCheckBox = new javax.swing.JCheckBox();
        playerOnlyFlagCheckBox = new javax.swing.JCheckBox();
        defaultFlagsBtn = new javax.swing.JButton();
        highColorArea = new javax.swing.JPanel();
        mapHighColorBtn = new javax.swing.JButton();
        mapLowColorBtn = new javax.swing.JButton();
        lowColorArea = new javax.swing.JPanel();
        waypointsColorBtn = new javax.swing.JButton();
        waypointsColorArea = new javax.swing.JPanel();
        includeFlagsRadioButton = new javax.swing.JRadioButton();
        excludeFlagsRadioButton = new javax.swing.JRadioButton();

        mapFlagsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(TimelinePanel.class, "LBL_MapFlagsPanel"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(walkFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.walkFlagCheckBox.text")); // NOI18N
        walkFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                walkFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(flyFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.flyFlagCheckBox.text")); // NOI18N
        flyFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                flyFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(swimFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.swimFlagCheckBox.text")); // NOI18N
        swimFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                swimFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jumpFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.jumpFlagCheckBox.text")); // NOI18N
        jumpFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jumpFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(doorFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.doorFlagCheckBox.text")); // NOI18N
        doorFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                doorsFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(specialFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.specialFlagCheckBox.text")); // NOI18N
        specialFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                specialFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(ladderFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.ladderFlagCheckBox.text")); // NOI18N
        ladderFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                ladderFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(proscribedFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.proscribedFlagCheckBox.text")); // NOI18N
        proscribedFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                proscribedFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(forcedFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.forcedFlagCheckBox.text")); // NOI18N
        forcedFlagCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                forcedFlagCheckBoxStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(playerOnlyFlagCheckBox, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.playerOnlyFlagCheckBox.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(defaultFlagsBtn, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.defaultFlagsBtn.text")); // NOI18N
        defaultFlagsBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultFlagsBtnActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout mapFlagsPanelLayout = new javax.swing.GroupLayout(mapFlagsPanel);
        mapFlagsPanel.setLayout(mapFlagsPanelLayout);
        mapFlagsPanelLayout.setHorizontalGroup(
            mapFlagsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mapFlagsPanelLayout.createSequentialGroup()
                .addGroup(mapFlagsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(swimFlagCheckBox)
                    .addComponent(jumpFlagCheckBox)
                    .addComponent(doorFlagCheckBox)
                    .addComponent(specialFlagCheckBox)
                    .addComponent(ladderFlagCheckBox)
                    .addComponent(proscribedFlagCheckBox)
                    .addComponent(forcedFlagCheckBox)
                    .addComponent(playerOnlyFlagCheckBox)
                    .addGroup(mapFlagsPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(defaultFlagsBtn))
                    .addComponent(flyFlagCheckBox)
                    .addComponent(walkFlagCheckBox))
                .addContainerGap(11, Short.MAX_VALUE))
        );
        mapFlagsPanelLayout.setVerticalGroup(
            mapFlagsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mapFlagsPanelLayout.createSequentialGroup()
                .addComponent(walkFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(flyFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(swimFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jumpFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(doorFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(specialFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ladderFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(proscribedFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(forcedFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(playerOnlyFlagCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(defaultFlagsBtn)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        highColorArea.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        javax.swing.GroupLayout highColorAreaLayout = new javax.swing.GroupLayout(highColorArea);
        highColorArea.setLayout(highColorAreaLayout);
        highColorAreaLayout.setHorizontalGroup(
            highColorAreaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );
        highColorAreaLayout.setVerticalGroup(
            highColorAreaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        org.openide.awt.Mnemonics.setLocalizedText(mapHighColorBtn, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.mapHighColorBtn.text")); // NOI18N
        mapHighColorBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mapHighColorBtnActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(mapLowColorBtn, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.mapLowColorBtn.text")); // NOI18N
        mapLowColorBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mapLowColorBtnActionPerformed(evt);
            }
        });

        lowColorArea.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        javax.swing.GroupLayout lowColorAreaLayout = new javax.swing.GroupLayout(lowColorArea);
        lowColorArea.setLayout(lowColorAreaLayout);
        lowColorAreaLayout.setHorizontalGroup(
            lowColorAreaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );
        lowColorAreaLayout.setVerticalGroup(
            lowColorAreaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        org.openide.awt.Mnemonics.setLocalizedText(waypointsColorBtn, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.waypointsColorBtn.text")); // NOI18N
        waypointsColorBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                waypointsColorBtnActionPerformed(evt);
            }
        });

        waypointsColorArea.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        javax.swing.GroupLayout waypointsColorAreaLayout = new javax.swing.GroupLayout(waypointsColorArea);
        waypointsColorArea.setLayout(waypointsColorAreaLayout);
        waypointsColorAreaLayout.setHorizontalGroup(
            waypointsColorAreaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );
        waypointsColorAreaLayout.setVerticalGroup(
            waypointsColorAreaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );

        FlagsBehaviorRadioGroup.add(includeFlagsRadioButton);
        includeFlagsRadioButton.setSelected(true);
        includeFlagsRadioButton.setToolTipText(org.openide.util.NbBundle.getMessage(TimelinePanel.class, "LBL_IncludeFlags")); // NOI18N
        includeFlagsRadioButton.setLabel(org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.includeFlagsRadioButton.label")); // NOI18N
        includeFlagsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                includeFlagsRadioButtonActionPerformed(evt);
            }
        });

        FlagsBehaviorRadioGroup.add(excludeFlagsRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(excludeFlagsRadioButton, org.openide.util.NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.jRadioButton2.text")); // NOI18N
        excludeFlagsRadioButton.setToolTipText(org.openide.util.NbBundle.getMessage(TimelinePanel.class, "LBL_ForceFlags")); // NOI18N
        excludeFlagsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                excludeFlagsRadioButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(mapFlagsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(waypointsColorBtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(mapLowColorBtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(mapHighColorBtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(waypointsColorArea, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(lowColorArea, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(highColorArea, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addComponent(includeFlagsRadioButton)
                    .addComponent(excludeFlagsRadioButton))
                .addGap(399, 399, 399))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(mapFlagsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(19, 19, 19)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(highColorArea, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(mapHighColorBtn, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(lowColorArea, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(mapLowColorBtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(waypointsColorArea, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(waypointsColorBtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGap(26, 26, 26)
                        .addComponent(includeFlagsRadioButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(excludeFlagsRadioButton)))
                .addContainerGap(100, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void defaultFlagsBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultFlagsBtnActionPerformed
        // Set flags to default
        walkFlagCheckBox.setSelected(MapFlag.WALK.getDefault());
        flyFlagCheckBox.setSelected(MapFlag.FLY.getDefault());
        swimFlagCheckBox.setSelected(MapFlag.SWIM.getDefault());
        jumpFlagCheckBox.setSelected(MapFlag.JUMP.getDefault());
        doorFlagCheckBox.setSelected(MapFlag.DOOR.getDefault());
        specialFlagCheckBox.setSelected(MapFlag.SPECIAL.getDefault());
        ladderFlagCheckBox.setSelected(MapFlag.LADDER.getDefault());
        proscribedFlagCheckBox.setSelected(MapFlag.PROSCRIBED.getDefault());
        forcedFlagCheckBox.setSelected(MapFlag.FORCED.getDefault());
        playerOnlyFlagCheckBox.setSelected(MapFlag.PLAYER_ONLY.getDefault());
    }//GEN-LAST:event_defaultFlagsBtnActionPerformed

    private void mapHighColorBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mapHighColorBtnActionPerformed
        String title = NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.mapsHighColorChooser.title");
        Color chosenHighColor = JColorChooser.showDialog(this, title, highColorArea.getBackground());
        highColorArea.setBackground(chosenHighColor);
        NbPreferences.forModule(TimelinePanel.class).putInt(MapColor.HIGH_COLOR_KEY.getPrefKey(), chosenHighColor.getRGB());
    }//GEN-LAST:event_mapHighColorBtnActionPerformed

    private void mapLowColorBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mapLowColorBtnActionPerformed
        String title = NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.mapsLowColorChooser.title");
        Color chosenLowColor = JColorChooser.showDialog(this, title, lowColorArea.getBackground());
        lowColorArea.setBackground(chosenLowColor);
        NbPreferences.forModule(TimelinePanel.class).putInt(MapColor.LOW_COLOR_KEY.getPrefKey(), chosenLowColor.getRGB());
    }//GEN-LAST:event_mapLowColorBtnActionPerformed

    private void waypointsColorBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_waypointsColorBtnActionPerformed
        String title = NbBundle.getMessage(TimelinePanel.class, "TimelinePanel.mapWaypointsColorChooser.title");
        Color chosenWaypointsColor = JColorChooser.showDialog(this, title, waypointsColorArea.getBackground());
        waypointsColorArea.setBackground(chosenWaypointsColor);
        NbPreferences.forModule(TimelinePanel.class).putInt(MapColor.WAYPOINTS_COLOR_KEY.getPrefKey(), chosenWaypointsColor.getRGB());
    }//GEN-LAST:event_waypointsColorBtnActionPerformed

    private void walkFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_walkFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.WALK.getPrefKey(), walkFlagCheckBox.isSelected());
    }//GEN-LAST:event_walkFlagCheckBoxStateChanged

    private void flyFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_flyFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.FLY.getPrefKey(), flyFlagCheckBox.isSelected());
    }//GEN-LAST:event_flyFlagCheckBoxStateChanged

    private void swimFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_swimFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.SWIM.getPrefKey(), swimFlagCheckBox.isSelected());
    }//GEN-LAST:event_swimFlagCheckBoxStateChanged

    private void jumpFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jumpFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.JUMP.getPrefKey(), jumpFlagCheckBox.isSelected());
    }//GEN-LAST:event_jumpFlagCheckBoxStateChanged

    private void doorsFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_doorsFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.DOOR.getPrefKey(), doorFlagCheckBox.isSelected());
    }//GEN-LAST:event_doorsFlagCheckBoxStateChanged

    private void specialFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_specialFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.SPECIAL.getPrefKey(), specialFlagCheckBox.isSelected());
    }//GEN-LAST:event_specialFlagCheckBoxStateChanged

    private void ladderFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_ladderFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.LADDER.getPrefKey(), ladderFlagCheckBox.isSelected());
    }//GEN-LAST:event_ladderFlagCheckBoxStateChanged

    private void proscribedFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_proscribedFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.PROSCRIBED.getPrefKey(), proscribedFlagCheckBox.isSelected());
    }//GEN-LAST:event_proscribedFlagCheckBoxStateChanged

    private void forcedFlagCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_forcedFlagCheckBoxStateChanged
        NbPreferences.forModule(TimelinePanel.class).putBoolean(MapFlag.FORCED.getPrefKey(), forcedFlagCheckBox.isSelected());
    }//GEN-LAST:event_forcedFlagCheckBoxStateChanged

    private void includeFlagsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_includeFlagsRadioButtonActionPerformed
        NbPreferences.forModule(TimelinePanel.class).putBoolean(INCLUDE_FLAG_KEY, true);
    }//GEN-LAST:event_includeFlagsRadioButtonActionPerformed

    private void excludeFlagsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_excludeFlagsRadioButtonActionPerformed
        NbPreferences.forModule(TimelinePanel.class).putBoolean(INCLUDE_FLAG_KEY, false);
    }//GEN-LAST:event_excludeFlagsRadioButtonActionPerformed

    void load() {
        // Set flags of map

        Preferences pref = NbPreferences.forModule(TimelinePanel.class);
        
        walkFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.WALK));
        flyFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.FLY));

        swimFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.SWIM));
        jumpFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.JUMP));

        doorFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.DOOR));
        specialFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.SPECIAL));

        ladderFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.LADDER));
        proscribedFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.PROSCRIBED));
        
        forcedFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.FORCED));
        playerOnlyFlagCheckBox.setSelected(getPrefBoolean(pref, MapFlag.PLAYER_ONLY));

        // Colors
        lowColorArea.setBackground(getPrefColor(pref, MapColor.LOW_COLOR_KEY));
        highColorArea.setBackground(getPrefColor(pref, MapColor.HIGH_COLOR_KEY));
        waypointsColorArea.setBackground(getPrefColor(pref, MapColor.WAYPOINTS_COLOR_KEY));

        if (pref.getBoolean(INCLUDE_FLAG_KEY, true)) {
            includeFlagsRadioButton.setSelected(true);
        } else {
            excludeFlagsRadioButton.setSelected(true);
        }
    }

    private Color getPrefColor(Preferences pref, MapColor color) {
        return new Color(pref.getInt(color.getPrefKey(), color.getDegaultARGB()));
    }

    private boolean getPrefBoolean(Preferences pref, MapFlag flag) {
        return pref.getBoolean(flag.getPrefKey(), flag.getDefault());
    }

    void store() {
        Preferences pref = NbPreferences.forModule(TimelinePanel.class);

        // flags
        pref.putBoolean(MapFlag.WALK.getPrefKey(), walkFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.FLY.getPrefKey(), flyFlagCheckBox.isSelected());

        pref.putBoolean(MapFlag.SWIM.getPrefKey(), swimFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.JUMP.getPrefKey(), jumpFlagCheckBox.isSelected());

        pref.putBoolean(MapFlag.DOOR.getPrefKey(), doorFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.SPECIAL.getPrefKey(), specialFlagCheckBox.isSelected());

        pref.putBoolean(MapFlag.LADDER.getPrefKey(), ladderFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.PROSCRIBED.getPrefKey(), proscribedFlagCheckBox.isSelected());

        pref.putBoolean(MapFlag.FORCED.getPrefKey(), forcedFlagCheckBox.isSelected());
        pref.putBoolean(MapFlag.PLAYER_ONLY.getPrefKey(), playerOnlyFlagCheckBox.isSelected());

        // Low Color
        Color lowColor = this.lowColorArea.getBackground();
        pref.putInt(MapColor.LOW_COLOR_KEY.getPrefKey(), lowColor.getRGB());

        // High Color
        Color highColor = this.highColorArea.getBackground();
        pref.putInt(MapColor.HIGH_COLOR_KEY.getPrefKey(), highColor.getRGB());

        // Waypoints
        Color waypointsColor = this.waypointsColorArea.getBackground();
        pref.putInt(MapColor.WAYPOINTS_COLOR_KEY.getPrefKey(), waypointsColor.getRGB());

        pref.putBoolean(INCLUDE_FLAG_KEY, includeFlagsRadioButton.isSelected());
    }


    /**
     * Key for behavior of include flags
     */
    public final static String INCLUDE_FLAG_KEY = "includeFlagToRendering";

    /**
     * List of preferrences of colors related to visualization of map.
     */
    public static enum MapColor {
        LOW_COLOR_KEY("mapLowColorARGB", Color.WHITE.getRGB()),
        HIGH_COLOR_KEY("mapHighColorARGB", Color.RED.getRGB()),
        WAYPOINTS_COLOR_KEY("mapWaypointsColorARGB", new Color(0.6f, 0.6f, 0.6f).getRGB());

        private String prefKey;
        private int defaultARGB;
        private MapColor(String prefKey, int defaultARGB) {
            this.prefKey = prefKey;
            this.defaultARGB = defaultARGB;
        }

        /**
         * Get preferences key for TimelinePanel.
         * <p>
         * Get the value of preference through NbPreferences.forModule(TimelinePanel.class).getBoolean(String prefKey, boolean ifNothingSet)
         * @return
         */
        public String getPrefKey() {
            return prefKey;
        }

        /**
         * Get defualt color represented by in in format defined in Color.getRGB()
         * @return
         */
        public int getDegaultARGB() {
            return defaultARGB;
        }

        /**
         * Get default color of the preferrence
         * @return
         */
        public Color getDefaultColor() {
            return new Color(defaultARGB);
        }
    }

    /**
     * List of preferrences flags related to links between waypoints in unreal map.
     */
    public static enum MapFlag {
        WALK("mapFlagWalk", 1, true),
        FLY("mapFlagFlyFly", 2, false),
        SWIM("mapFlagSwim", 4, false),
        JUMP("mapFlagJump", 8, false),
        DOOR("mapFlagDoor", 16, true),
        SPECIAL("mapFlagSpecial", 32, true),
        LADDER("mapFlagLadder", 64, true),
        PROSCRIBED("mapFlagProscribed", 128, true),
        FORCED("mapFlagForced", 256, true),
        PLAYER_ONLY("mapFlagPlayerOnly", 512, true);

        private final String prefKey;
        private final int flag;
        private final boolean defaultValue;

        private MapFlag(String prefKey, int flag, boolean defaultValue) {
            this.prefKey = prefKey;
            this.flag = flag;
            this.defaultValue = defaultValue;
        }

        /**
         * Get preferences key for TimelinePanel.
         * <p>
         * Get the value of preference through NbPreferences.forModule(TimelinePanel.class).getBoolean(String prefKey, boolean ifNothingSet)
         * @return
         */
        public String getPrefKey() {
            return prefKey;
        }

        /**
         * Get default value of this flag
         * @return wheather to show or not show edges wioth this flag
         */
        public boolean getDefault() {
            return defaultValue;
        }

        /**
         * Return int value that is used by unreal engine to represent this flag
         * in waylinks.
         * @return 1 bit integer (2^n, like 1,2,4,8,..)
         */
        public int getFlag() {
            return flag;
        }

        @Override
        public String toString() {
            return prefKey;
        }
    }


    boolean valid() {
        // TODO check whether form is consistent and complete
        return true;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup FlagsBehaviorRadioGroup;
    private javax.swing.JButton defaultFlagsBtn;
    private javax.swing.JCheckBox doorFlagCheckBox;
    private javax.swing.JRadioButton excludeFlagsRadioButton;
    private javax.swing.JCheckBox flyFlagCheckBox;
    private javax.swing.JCheckBox forcedFlagCheckBox;
    private javax.swing.JPanel highColorArea;
    private javax.swing.JRadioButton includeFlagsRadioButton;
    private javax.swing.JCheckBox jumpFlagCheckBox;
    private javax.swing.JCheckBox ladderFlagCheckBox;
    private javax.swing.JPanel lowColorArea;
    private javax.swing.JPanel mapFlagsPanel;
    private javax.swing.JButton mapHighColorBtn;
    private javax.swing.JButton mapLowColorBtn;
    private javax.swing.JCheckBox playerOnlyFlagCheckBox;
    private javax.swing.JCheckBox proscribedFlagCheckBox;
    private javax.swing.JCheckBox specialFlagCheckBox;
    private javax.swing.JCheckBox swimFlagCheckBox;
    private javax.swing.JCheckBox walkFlagCheckBox;
    private javax.swing.JPanel waypointsColorArea;
    private javax.swing.JButton waypointsColorBtn;
    // End of variables declaration//GEN-END:variables
}
