/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.logging;

import cz.cuni.amis.nb.pogamut.base.logging.LogRecordListener;
import cz.cuni.amis.nb.pogamut.base.logging.LogRecordsSource;
import cz.cuni.amis.nb.pogamut.base.logging.LogViewerPane;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class LogTableModel
extends DefaultTableModel
implements LogRecordListener {
    int limit = 100;
    boolean freezed = false;
    Set<LogRecordsSource> dataSources = new HashSet<LogRecordsSource>();
    protected static SimpleDateFormat dateFormat = new SimpleDateFormat("H : mm : s.S");

    public LogTableModel() {
        ResourceBundle bundle = NbBundle.getBundle(LogViewerPane.class);
        this.setColumnIdentifiers(new Object[]{bundle.getString("LBL_Time"), bundle.getString("LBL_Level"), bundle.getString("LBL_Message")});
    }

    public void setFreeze(boolean freezed) {
        this.freezed = freezed;
    }

    public boolean isFreezed() {
        return this.freezed;
    }

    public Set<LogRecordsSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void addDataSource(LogRecordsSource source) {
        this.dataSources.add(source);
        source.addLogRecordListener(this);
    }

    public void removeDataSource(LogRecordsSource source) {
        this.dataSources.remove(source);
        source.removeLogRecordListener(this);
    }

    public void removeAllDataSources() {
        Iterator<LogRecordsSource> i = null;
        while (!this.dataSources.isEmpty()) {
            i = this.dataSources.iterator();
            this.removeDataSource(i.next());
        }
    }

    protected Vector logRecToVector(LogRecord r) {
        Vector<LogLevelObject> v = new Vector<LogLevelObject>();
        v.add(new LogLevelObject(r.getLevel(), dateFormat.format(new Date(r.getMillis()))));
        v.add(new LogLevelObject(r.getLevel(), r.getLevel()));
        v.add(new LogLevelObject(r.getLevel(), r.getMessage()));
        return v;
    }

    @Override
    public void notifyNewLogRecord(LogRecord r) {
        if (!this.freezed) {
            this.insertRow(0, this.logRecToVector(r));
            if (this.getRowCount() > this.limit && this.getRowCount() > 0) {
                this.removeRow(this.getRowCount() - 1);
            }
        }
    }

    public void setRowLimit(int limit) {
        this.limit = limit;
    }

    public int getRowLimit() {
        return this.limit;
    }

    @Override
    public void setNewData(Collection<LogRecord> r) {
        this.dataVector.clear();
        for (LogRecord record : r) {
            this.dataVector.add(this.logRecToVector(record));
        }
        this.fireTableDataChanged();
    }

    public class LogLevelObject {
        public Level level;
        public Object msg;

        public String toString() {
            return this.msg.toString();
        }

        public LogLevelObject(Level level, Object msg) {
            this.level = level;
            this.msg = msg;
        }
    }
}

