package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import java.util.HashMap;

/**
 * Enum holding all available Pogamut items in UnrealEngine2RuntimeDemo.
 * @author knight
 */
public enum ItemTypeUE2 {

    ITEMBALL("GBEmohawk.ItemBall"),
    ITEMBOOK("GBEmohawk.ItemBook"),
    ITEMBOOKOPENED("GBEmohawk.ItemBookOpened"),
    ITEMBROCCOLI("GBEmohawk.ItemBroccoli"),
    ITEMCONDOM("GBEmohawk.ItemCondom"),
    ITEMCOOKER("GBEmohawk.ItemCooker"),
    ITEMCUP("GBEmohawk.ItemCup"),
    ITEMDICE("GBEmohawk.ItemDice"),
    ITEMFLOWER("GBEmohawk.ItemFlower"),
    ITEMGUN("GBEmohawk.ItemGun"),
    ITEMHEART("GBEmohawk.ItemHeart"),
    ITEMPLATE("GBEmohawk.ItemPlate"),
    ITEMPOT("GBEmohawk.ItemPot"),
    ITEMSHOES("GBEmohawk.ItemShoes"),
    ITEMSHOESUNTIDY("GBEmohawk.ItemShoesUntidy"),
    ITEMSOAP("GBEmohawk.ItemSoap"),
    ITEMSOAPBOX("GBEmohawk.ItemSoapbox"),
    ITEMSPOON("GBEmohawk.ItemSpoon"),
    ITEMTEDDY("GBEmohawk.ItemTeddy"),
    ITEMTOOTHBRUSH("GBEmohawk.ItemToothbrush"),
    NONE("None");

    /** Name of the class representing the object in UE2 */
    String unrealName;

    public static HashMap<String, ItemTypeUE2> nameMap = new HashMap();

    public static ItemTypeUE2 getItemType(String name) {
        if (nameMap.containsKey(name))
            return nameMap.get(name);
        else
            return ItemTypeUE2.NONE;
    }

    public String getUnrealName() {
        return unrealName;
    }

    ItemTypeUE2(String unrealName) {
        this.unrealName = unrealName;
    }

    static {
        for (ItemTypeUE2 type : ItemTypeUE2.values()) {
            nameMap.put(type.getUnrealName(), type);
        }
    }
}
