package cz.cuni.amis.pogamut.emohawk.factory.guice.remoteagent;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;

import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceRemoteAgentModule;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotController;
import cz.cuni.amis.pogamut.emohawk.communication.EmohawkYylex;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.EmohawkWorldView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.BatchClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectBeliefRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.ViewableObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.ViewableObjectBeliefRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.IWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.HistoricWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.IHistoricWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.ISightingMemory;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.SnapshotMemorizer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.IObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.ReplicationWorldObjectUpdater;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.parser.IUT2004Yylex;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004CommunicationModule;

/** Dependency injector for {@link EmohawkBotController}.
 * 
* Newly binded classes:
 * <table>
 * <tr><th>Mapped class</th>                    <th>  </th> <th>Target</th>                         <th>Description</th></tr>
 * 
 * <tr><td>{@link IUT2004Yylex}</td>			<td>-></td>	<td>{@link EmohawkYylex}</td>			<td>Binds yylex to specialized emohawk implementation.</td></tr>
 * <tr><td>{@link ILockableVisionWorldView}</td><td>-></td> <td>{@link EmohawkWorldView}</td> 		<td>Binds world view to specialized emohawk implementation.</td></tr>
 * 
 * <tr><td>{@link IHistoricWorldObjectUpdater}</td>	<td>-></td> <td>{@link HistoricWorldObjectUpdater}</td> 	<td>Binds historic object updater to basic implementation.</td></tr>
 * <tr><td>{@link IViewableObjectBeliefRegistry}</td>	<td>-></td> <td>{@link ViewableObjectBeliefRegistry}</td> 	<td>Binds world object belief registry to basic implementation.</td></tr> 
 * <tr><td>{@link ISimulationClock}</td>	<td>-></td> <td>{@link BatchClock}</td> 	<td>Binds simulation clock to batch clock.</td></tr>
 *  
 * <tr><td>{@link IWorldObjectUpdater} annotated with {@link HistoricWorldObjectUpdater#CLASS_NAME}</td>	<td>-></td> <td>{@link ReplicationWorldObjectUpdater}</td> 	<td>Bind internal nonhistoric updater of historic world object updater to replication world object updater.</td></tr>
 * <tr><td>{@link IViewableObjectRegistry}</td>	<td>-></td> <td>{@link ViewableObjectRegistry}</td> 	<td>Binds viewable world object registry to basic implementation.</td></tr>
 * <tr><td>{@link ISightingMemory}</td>	<td>-></td> <td>{@link SightingMemory}</td> 	<td>Binds sighting memory to basic implementation.</td></tr>
 * <tr><td>{@link ISnapshotMemorizer}</td>	<td>-></td> <td>{@link SnapshotMemorizer}</td> 	<td>Binds snapshot memorizer to emohawk implementation.</td></tr> 
 * 
 * <tr><td>{@link IObjectReplicationClient}</td>	<td>-></td> <td>{@link ObjectReplicationClient}</td> 	<td>Binds object replication client to emohawk implementation.</td></tr>
 * </table>
 * 
 * To have <b>successful module</b> the descendant <b>must specify</b> these <b>missing bindings</b>:
 * <table>
 * <tr><th>Mapped class</th>                    <th>Description</th></tr>
 * 
 * <tr><td>{@link IUT2004BotController}</td>    <td>Controller of the bot.</td></tr>
 * </table>
 * 
 * @see UT2004CommunicationModule
 * @see GuiceRemoteAgentModule
 * @see GuiceAgentModule
 * @author Paletz
 */
public class EmohawkBotModule<PARAMS extends UT2004BotParameters> extends UT2004BotModule<PARAMS> {

	public EmohawkBotModule( Class<? extends IUT2004BotController<?> > botControllerClass ) {
		super(botControllerClass);
	}
	
	@Override
	protected void configureModules() {
		super.configureModules();
		
		addModule(
			new AbstractModule() {
				@Override
				protected void configure() {
					// yylex
					bind(IUT2004Yylex.class).to(EmohawkYylex.class);
					
					// world view
					bind(ILockableVisionWorldView.class).to(EmohawkWorldView.class);
					
					// world view components
					bind(ComponentDependencies.class).annotatedWith(Names.named(EmohawkWorldView.WORLDVIEW_DEPENDENCY)).toProvider(worldViewDependenciesProvider);
					bind(IHistoricWorldObjectUpdater.class).to(HistoricWorldObjectUpdater.class);
					bind(IViewableObjectBeliefRegistry.class).to(ViewableObjectBeliefRegistry.class);
					bind(ISimulationClock.class).to(BatchClock.class);
					
					// historic world object updater components
					bind(IWorldObjectUpdater.class).to(ReplicationWorldObjectUpdater.class);
					bind(IViewableObjectRegistry.class).to(ViewableObjectRegistry.class);
					bind(ISightingMemory.class).to(SightingMemory.class);
					bind(ISnapshotMemorizer.class).to(SnapshotMemorizer.class);
									
					// Replication object updater components
					bind(IObjectReplicationClient.class).to(ObjectReplicationClient.class);
				}
			}
		);
	}
}
