package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.worldObject;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.worldObject.IViewableObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.AttributeManagerReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractObjectReplica;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;

/** Abstract viewable world object replica
 *
 * Equivalent of UDK EhAbstractUniqueGameObject and EhAbstractEssence.
 */
public abstract  class AbstractViewableObjectReplica extends AbstractObjectReplica implements IViewableObjectReplica {
	
	protected AttributeManagerReplica attributes;
	protected WorldObjectId worldObjectId;
		
	@Override
	public void receive( IObjectInputStream stream ) {
		attributes = (AttributeManagerReplica) stream.readObjectRef();
		worldObjectId = WorldObjectId.get( stream.readInt() );
	}
	
	@Override
	public boolean isVisible() {
		return isLive();
	}
	
	@Override
	public ILocalWorldObject getLocal() {
		return null; // unused multiview stub
	}

	@Override
	public ISharedWorldObject getShared() {
		return null; // unused multiview stub
	}

	@Override
	public IStaticWorldObject getStatic() {
		return null; // unused multiview stub
	}
	
	@Override
	public WorldObjectId getId() {
		return worldObjectId;
	}
	
	@Override
	public long getSimTime() {
		return objectReplicationClient.getSimulationClock().getTime().getMilliSeconds();
	}
}