package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.worldObject;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.worldObject.IEntityReplica;

/** Physical entity replica
 *
 * Equivalent of UDK EhAbstractEntityEssence.
 * 
 * @author Paletz
 */
public class AbstractEntityReplica extends AbstractViewableObjectReplica implements IEntityReplica {

	protected SituationReplica situation;
	
	@Override
	public Location getLocation() {
		if ( situation == null ) {
			return null;
		}
		return situation.getLocation();
	}

	@Override
	public Velocity getVelocity() {
		if ( situation == null ) {
			return null;
		}
		return situation.getVelocity();
	}

	@Override
	public Rotation getRotation() {
		if ( situation == null ) {
			return null;
		}
		return situation.getRotation();
	}
	
	/** Get situation
	 * 
	 * @return situation
	 */
	public SituationReplica getSituation() {
		return situation;
	}


	@Override
	public void receive(IObjectInputStream stream) {
		super.receive(stream);
		situation = (SituationReplica) stream.readObjectRef();
	}
}
