package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.sll;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Singly-linked list
 */
public class SinglyLinkedListReplica<Element> extends AbstractGenericObjectReplica implements Collection<Element> {

	protected SinglyLinkedListNodeReplica<Element> head;
	protected SinglyLinkedListNodeReplica<Element> last;
	protected int size;

	public SinglyLinkedListReplica() {
		super( 1 );
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	public SpecializedClass<Element> getValueClass() {
		@SuppressWarnings("unchecked")
		SpecializedClass<Element> tmp = (SpecializedClass<Element>) typeParameters[0];
		return tmp;
	}
	
	@Override
	public int size() {
		return size;
	}

	@Override
	public boolean isEmpty() {
		return ( last == null );
	}
	
	@Override
	public Iterator<Element> iterator() {
		return new SinglyLinkedListIterator( head.getNext() );
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public void receive( IObjectInputStream stream ) {
		head = (SinglyLinkedListNodeReplica<Element>) stream.readObjectRef();
		assert( head.getValueClass().equals( getValueClass() ) );
		last = (SinglyLinkedListNodeReplica<Element>) stream.readObjectRef();
		assert( last == null || last.getValueClass().equals( getValueClass() ) );
		size = stream.readInt();
	}
	
	/** Iterator implementation
	 */
	protected class SinglyLinkedListIterator implements Iterator<Element> {
		
		protected SinglyLinkedListNodeReplica<Element> next;
		
		public SinglyLinkedListIterator( SinglyLinkedListNodeReplica<Element> next ) {
			this.next = next;
		}
		
		@Override
		public boolean hasNext() {
			return next != null;
		}

		@Override
		public Element next() {
			Element retval = next.getValue();
			next = next.getNext();
			return retval;
		}
		
		@Override
		public void remove() {
			throw new UnsupportedOperationException( "SinglyLinkedList replica is read-only." );
		}
	}

	@Override
	public boolean contains(Object o) {
		for ( Element element : this ) {
			if ( o.equals(element) ) {
				return true;
			}
		}
		return false;
	}

	@Override
	public Object[] toArray() {
		Object[] array = new Object[size()];
		int i=0;
		for ( Element element : this ) {
			array[i] = element;
			++i;
		}
		return array;
	}

	@Override
	public <T> T[] toArray( T[] array ) {
	    if (array.length < size() ) {
	    	@SuppressWarnings("unchecked")
			T[] tmp = (T[]) Array.newInstance( array.getClass().getComponentType(), size() );
	        array = tmp; 
	    } else if (array.length > size() ) {
	        array[size()] = null;
	    }
	    
	    int i = 0;
	    for ( Element element : this) {
	    	@SuppressWarnings("unchecked")
			T tmp = (T) element ;
	        array[i] = tmp;
	        i++;
	    }
	    return array;
	}

	@Override
	public boolean add(Element e) {
		throw new UnsupportedOperationException( "Read-only" );
	}

	@Override
	public boolean remove(Object o) {
		throw new UnsupportedOperationException( "Read-only" );
	}

	@Override
	public boolean containsAll( Collection<?> collection ) {
		for ( Object object : collection ) {
			if ( !contains( object) ) {
				return false;
			}
		}
		return true;
	}

	@Override
	public boolean addAll(Collection<? extends Element> c) {
		throw new UnsupportedOperationException( "Read-only" );
	}

	@Override
	public boolean removeAll(Collection<?> c) {
		throw new UnsupportedOperationException( "Read-only" );
	}

	@Override
	public boolean retainAll(Collection<?> c) {
		throw new UnsupportedOperationException( "Read-only" );
	}

	@Override
	public void clear() {
		throw new UnsupportedOperationException( "Read-only" );
	}
}