package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;

/** A casted view of a foggy reference
 * 
 * @author Paletz
 *
 * @param <T>
 */
public abstract class FoggyReferenceCaster<T> implements IFoggyReference<T>{

	IFoggyReference<?> rawRef;

	public FoggyReferenceCaster( IFoggyReference<?> rawRef ) {
		this.rawRef = rawRef;
	}
	
	protected abstract T cast( Object object );
	
	@Override
	public T getNotHidden() {
		return cast( rawRef.getNotHidden() );
	}

	@Override
	public T getHiddenAsNull() {
		return cast( rawRef.getHiddenAsNull() );
	}

	@Override
	public boolean isHidden() {
		return rawRef.isHidden();
	}

	@Override
	public boolean isSet() {
		return rawRef.isSet();
	};
}
