package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.primitive;

import java.util.Iterator;
import java.util.Map.Entry;

/** Interface of view of attributes matching the templated primitive type
 * 
 * Provides exists, get and set operations. 
 */
public interface IPrimitiveAttributeView<T>  {

	/** Get value of an existing attribute
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value
	 */
	public T get( String attributeName );
	
	/** Tell if attribute exists and has the right type and access
	 *
	 * @param attributeName attribute name
	 * @return true if attribute exists and has right type and access
	 */
	public boolean exists( String attributeName );
	
	/** Iterate over attributes in the view
	 *
	 * @return read-only iterator over attributes in the view
	 */
	public Iterator<Entry<String,PrimitiveAttributeReplica<T>>> iterator();
}