package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRefList;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.FoggyReferenceReplica;

/** Foggy reference list attribute view inteface
 */
public interface IFoggyRefListAttributeView {

	/** Get read-only value list of an existing attribute
	 * 
	 * Not available for write attributes on client-side.
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value list
	 */
	 Collection<FoggyReferenceReplica<IObjectReplica>> read( String attributeName );
		
	/** Tell if attribute exists and has the right type and access
	 * 
	 * @param attributeName attribute name
	 * @return true if attribute exists and has the right type, false otherwise
	 */
	boolean exists( String attributeName );
	
	/** Iterate over attributes in the view
	 *
	 * @return read-only iterator over attributes in the view
	 */
	Iterator<Entry<String,FoggyRefListAttributeReplica>> iterator();
}