package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRef;

import java.util.Iterator;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
	
/** Interface of view of foggy reference attributes
 * 
 * Provides add, remove, exists, isHidden, get and set operations. 
 */
public interface IFoggyRefAttributeView {
	
	/** Get value of an existing attribute
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value
	 */
	IFoggyReference<IObjectReplica> get( String attributeName );
	
	/** Tell if attribute exists and has the right type and access
	 *
	 * @param attributeName attribute name
	 * @return true if attribute exists and has the right type, false otherwise
	 */
	boolean exists( String attributeName );
	
	/** Iterate over attributes in the view
	 *
	 * @return read-only iterator over attributes in the view
	 */
	Iterator<Entry<String,FoggyRefAttributeReplica>> iterator();
}