package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.ObjectReplicationClient;

/** Object replicated from Unreal script
 */
public interface IObjectReplica {

	/** Get replication index
	 * 
	 * @return replication index assigned by the replication server
	 */
	int getReplicationIndex();
		
	/** Receive object state from server
	 *  
	 * @param stream input stream, contains data sent by send(), all such data must be extracted, no less, no more
	 */
	void receive( IObjectInputStream stream );
	
	/** Initilize replica
	 *  
	 *  Called by object replication client to initialize replica object state.
	 */
	void initializeReplica( ObjectReplicationClient objectReplicationClient, int replicationIndex );
	
	/** Tell if object is an active replica
	 *
	 * @return true if object is active replica, false if object has been torn-off or never was image
	 */
	boolean isLive();
	
	/** Finalize replication
	 * 
	 * Called by object replication client or server to finalize replication state of the object.
	 */
	void finalizeReplication();
}
