package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.game;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.game.IGame;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.action.IActionRegistryMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.game.IGameMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.worldObject.AbstractViewableObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.game.GameReplica;

/** Game rules and state
 * 
 * @see IGame
 * @author Paletz
 */
public class GameMemorization extends AbstractViewableObjectMemorization implements IGameMemorization {

	protected IActionRegistryMemorization actionRegistry;
	
	/** Constructor
	 */
	public GameMemorization( 
		final GameReplica replica,
		final ISnapshotMemorizer snapshotMemorizer, 
		IDeferredConstructorChainer deferredConstructorChainer 
	) {
		super( replica, snapshotMemorizer, deferredConstructorChainer );
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					actionRegistry = (IActionRegistryMemorization) snapshotMemorizer.getMemorization( replica.getActionRegistry() );
				}
			}
		);
	}
	
	@Override
	public IActionRegistryMemorization getActionRegistry() {
		return actionRegistry;
	}
}
