package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.ds;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;

/** Foggy reference subrecord
 * 
 * Helper class to be used to record a foggy reference within a memorization.
 * 
 * @see IFoggyReference
 * @author Paletz
 */
public class FoggyReferenceMemorizationSubrecord
	<TMemorizationReference extends IObjectMemorization> 
	implements IFoggyReference<TMemorizationReference> {
	
	protected boolean isHidden;
	protected TMemorizationReference ref;
	protected Class<TMemorizationReference> referenceClass;
	
	public FoggyReferenceMemorizationSubrecord(
		boolean isHidden,
		TMemorizationReference ref,
		Class<TMemorizationReference> referenceClass
	) {
		this.isHidden = isHidden;
		this.ref = ref;
		this.referenceClass = referenceClass;
	}
	
	public static <TMemorizationReference extends IObjectMemorization> FoggyReferenceMemorizationSubrecord<TMemorizationReference> makeFromValue(
		boolean isHidden, 
		TMemorizationReference ref,
		Class<TMemorizationReference> referenceClass
	) {
		return new FoggyReferenceMemorizationSubrecord<TMemorizationReference>( isHidden, ref, referenceClass );
	}
	
	public static 
		<TMemorizationReference extends IObjectMemorization,TReplicaReference extends IObjectReplica>
		FoggyReferenceMemorizationSubrecord<TMemorizationReference> 
		makeFromReplica(
		ISnapshotMemorizer snapshotMemorizer,
		IFoggyReference<TReplicaReference> foggyReferenceReplica,
		Class<TMemorizationReference> referenceClass
	) {
		@SuppressWarnings("unchecked")
		TMemorizationReference ref = (TMemorizationReference) snapshotMemorizer.getMemorization( foggyReferenceReplica.getHiddenAsNull() );
		return new FoggyReferenceMemorizationSubrecord<TMemorizationReference>( foggyReferenceReplica.isHidden(), ref, referenceClass );
	};
		
	@Override
	public boolean isHidden() {
		return isHidden;
	}
	
	@Override
	public boolean isSet() {
		return isHidden() || getNotHidden() != null;
	}
	
	@Override
	public TMemorizationReference getNotHidden() {
		assert( !isHidden );
		return ref;
	}

	@Override
	public TMemorizationReference getHiddenAsNull() {
		return ref;
	}
	
	public Class<TMemorizationReference> getReferenceClass() {
		return referenceClass;
	}
}
