package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.pawn;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.pawn.IPawn;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory.BeliefSupport;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.pawn.IPawnBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.player.IPlayerBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.worldObject.AbstractEntityBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.pawn.IPawnMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.pawn.PawnMemorization;


/** Player-controlleable pawn memorization
 * 
 * Equivalent of UDK EhPawn.
 * 
 * @see IPawn
 * @author Paletz
 */
public class PawnBelief extends AbstractEntityBelief {

	/** Constructor
	 */
	public PawnBelief( PawnMemorization memorization, BeliefSupport beliefSupport ) {
		super(memorization, beliefSupport );
	}
	
	@Override
	public void updateMemorization( IObjectMemorization newMemorization ) {
		assert( newMemorization instanceof PawnMemorization );
		super.updateMemorization( newMemorization );
	}
	
	@Override
	public IPawnBelief getImmutableFacade() {
		return (IPawnBelief) immutableFacade;
	}

	@Override
	protected PawnBeliefImmutableFacade makeImmutableFacade() {
		return new PawnBeliefImmutableFacade();
	}
	
	protected PawnMemorization getMemorizationImpl() {
		return (PawnMemorization) memorization;
	}
	
	public class PawnBeliefImmutableFacade extends AbstractEntityBeliefImmutableFacade implements IPawnBelief {
		
		@Override
		public IPawnMemorization getMemorization() {
			return getMemorizationImpl();
		}

		@Override
		public IPlayerBelief getControllingPlayer() {
			return (IPlayerBelief) beliefSupport.getFreshestBelief( getMemorization().getControllingPlayer() );
		}
	}
}