package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.game;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.game.IGame;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory.BeliefSupport;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.action.IActionRegistryBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.game.IGameBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.worldObject.AbstractViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.game.IGameMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.game.GameMemorization;


/** Game rules and state
 * 
 * @see IGame
 * @author Paletz
 */
public class GameBelief extends AbstractViewableObjectBelief {

	/** Constructor
	 */
	public GameBelief( GameMemorization memorization, BeliefSupport beliefSupport ) {
		super(memorization, beliefSupport );
	}
	
	@Override
	public void updateMemorization( IObjectMemorization newMemorization ) {
		assert( newMemorization instanceof GameMemorization );
		super.updateMemorization( newMemorization );
	}
	
	@Override
	public IGameBelief getImmutableFacade() {
		return (IGameBelief) immutableFacade;
	}

	@Override
	protected GameBeliefImmutableFacade makeImmutableFacade() {
		return new GameBeliefImmutableFacade();
	}
	
	protected GameMemorization getMemorizationImpl() {
		return (GameMemorization) memorization;
	}
	
	public class GameBeliefImmutableFacade extends AbstractViewableObjectBeliefImmutableFacade implements IGameBelief {
		
		@Override
		public IGameMemorization getMemorization() {
			return getMemorizationImpl();
		}

		@Override
		public IActionRegistryBelief getActionRegistry() {
			return (IActionRegistryBelief) beliefSupport.getFreshestBelief( getMemorization().getActionRegistry() );
		}
	}
}