package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.ds;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory.BeliefSupport;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.worldObject.IViewableObjectMemorization;

/** Foggy reference converting memorization to belief backed up by foggy reference memorization getter
 * 
 * @author Paletz
 * 
 * @param <TMemorizationReference> memorization reference type
 * @param <TBeliefReference> belief reference type
 */
public class FoggyReferenceBeliefSubrecord
	<TMemorizationReference extends IViewableObjectMemorization, TBeliefReference extends IViewableObjectBelief>
	{

	protected Class<TMemorizationReference> memorizationReferenceClass;
	protected Class<TBeliefReference> beliefReferenceClass;
	protected IFoggyReference<? extends TMemorizationReference> memorizationSubrecord;
	protected ImmutableFacade immutableFacade;
	protected BeliefSupport beliefSupport;
	
	public FoggyReferenceBeliefSubrecord(
		BeliefSupport beliefSupport,
		Class<TMemorizationReference> memorizationReferenceClass,
		Class<TBeliefReference> beliefReferenceClass
	) {

		this.memorizationReferenceClass = memorizationReferenceClass;
		this.beliefSupport = beliefSupport;
		this.beliefReferenceClass = beliefReferenceClass;
		immutableFacade = new ImmutableFacade();
	}
	
	/** Update the subrecord
	 * 
	 * @param newMemorization
	 */
	public void updateMemorization( IFoggyReference<? extends TMemorizationReference> memorizationSubrecord ) {
		this.memorizationSubrecord = memorizationSubrecord;
	}
		
	/** Get immutable facade
	 * 
	 * The returned facade hides internal service methods.
	 * 
	 * @return immutable facade
	 */
	public IFoggyReference<TBeliefReference> getImmutableFacade() {
		return immutableFacade;
	}
	
	public class ImmutableFacade implements IFoggyReference<TBeliefReference> {
		
		@Override
		public TBeliefReference getNotHidden() {
			@SuppressWarnings("unchecked")
			TBeliefReference retval = (TBeliefReference) beliefSupport.getFreshestBelief( memorizationSubrecord.getNotHidden() );
			assert( retval == null || beliefReferenceClass.isInstance( retval ) );
			return retval;
		}

		@Override
		public TBeliefReference getHiddenAsNull() {
			@SuppressWarnings("unchecked")
			TBeliefReference retval = (TBeliefReference) beliefSupport.getFreshestBelief( memorizationSubrecord.getHiddenAsNull() );
			assert( retval == null || beliefReferenceClass.isInstance( retval ) );
			return retval;
		}

		@Override
		public boolean isHidden() {
			return memorizationSubrecord.isHidden();
		}

		@Override
		public boolean isSet() {
			return memorizationSubrecord.isSet();
		}
	}
}
