package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IWorldObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;

/** Sighting memory.
 *
 * Remembers sightings of world objects.
 * A sighting is forgotten when contradicted and older than short term memory duration.  
 * 
 * @author Paletz
 *
 */
public interface ISightingMemory {

	/** Observe currently visible world objects
	 */
	void refresh();
	
	/** Get duration of short term memory
	 * 
	 * Sightings are retained at least for this duration. 
	 * 
	 * @return duration of short term memory in seconds
	 */
	double getShortTermMemoryDuration();
	
	/** Set duration of short term memory
	 * 
	 * Sightings are retained at least for this duration. 
	 * 
	 * @param durationSeconds duration of short term memory
	 */
	void setShortTermMemoryDuration( double durationSeconds );
	
	/** Contradict a belief
	 * 
	 * Mark a belief contradicted.
	 * If belief already is contradicted, nothing happens.
	 * 
	 * @param belief belief to contradict, must not be visible
	 */
	void contradict( IViewableObjectBelief belief );
	
	/** Set input viewable world object registry
	 * 
	 * @param visibleWorldObjectListing input viewable world object registry
	 */
	void initInputViewableWorldObjectRegistry( IViewableObjectRegistry inputViewableWorldObjectRegistry );
	
	/** Set output world object registry
	 * 
	 * @param worldObjectRegistry output world object registry
	 */
	void initOutputWorldObjectRegistry( IWorldObjectRegistry worldObjectRegistry );

	/** Set simulation clock
	 * 
	 * @param simulationClock simulation clock
	 */
	void initSimulationClock(ISimulationClock simulationClock);

	/** Set snapshot memorizer
	 * 
	 * Used to create memorizations of beliefs.
	 * 
	 * @param memorizer memorizer
	 */
	void initMemorizer(ISnapshotMemorizer memorizer);
}
