package cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock;

import com.google.common.primitives.Longs;

public class SimulationTime {

	long timeMilliseconds;
	
	/** Constructor
	 * 
	 * @param timeMilliseconds time in milliseconds
	 */
	protected SimulationTime( long timeMilliseconds ) {
		this.timeMilliseconds = timeMilliseconds;
	}
	
	/** Create simulation time
	 * 
	 * @param timeMilliseconds time in milliseconds
	 */
	public static SimulationTime fromMilliSeconds( long timeMilliseconds ) {
		return new SimulationTime( timeMilliseconds );
	}
	
	/** Get simulation time in seconds
	 * 
	 * @return simulation time in seconds
	 */
	public double getSeconds() {
		return timeMilliseconds/1000;
	}
	
	/** Get simulation time in milliseconds
	 * 
	 * @return simulation time in milliseconds
	 */
	public long getMilliSeconds() {
		return timeMilliseconds;
	}
	
	@Override
	public int hashCode() {
		return Longs.hashCode(timeMilliseconds);
	}
	
	@Override
	public boolean equals(Object obj) {
		if ( obj instanceof SimulationTime ) {
			return timeMilliseconds == ((SimulationTime)obj).timeMilliseconds;
		}
		return false;
	}
}
