package cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;

public class BatchClock implements ISimulationClock {

	protected SimulationTime lastInitiatedBatchTime;
	protected SimulationTime lastFinishedBatchTime;
	
	public BatchClock() {
		lastInitiatedBatchTime = SimulationTime.fromMilliSeconds( Long.MIN_VALUE );
		lastFinishedBatchTime = lastInitiatedBatchTime;
	}

	@Override
	public SimulationTime getTime() {
		return lastInitiatedBatchTime;
	}

	public SimulationTime getTimeOfLastFinishedBatch() {
		return lastFinishedBatchTime;
	}
	
	@Override
	public void applyWorldChange( IWorldChangeEvent event ) {
		if ( event instanceof BeginMessage ) {
			lastInitiatedBatchTime = SimulationTime.fromMilliSeconds( event.getSimTime() );
		}
		if ( event instanceof EndMessage ) {
			lastFinishedBatchTime = lastInitiatedBatchTime;
		}
	}
}
