package cz.cuni.amis.pogamut.emohawk.communication.stream;

import java.util.LinkedList;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;

/** Object stream buffer
 * 
 * Adds object buffering.
 * 
 * @author Paletz
 */
public class ObjectStreamBuffer extends StreamBuffer implements IObjectInputStream {

	/** Clone
	 */
	@Override
	public ObjectStreamBuffer clone() {
		ObjectStreamBuffer retval = new ObjectStreamBuffer();
		retval.data = new LinkedList<Object>( data );
		return retval;
	}
	
	/** Write object reference
	 */
	public void writeObjectRef( IObjectReplica value ) {
		data.add( value );
	}
	
	@Override
	public IObjectReplica readObjectRef() {
		return (IObjectReplica) data.pop();
	}
	
	@Override
	public IObjectReplica peekObjectRef() {
		return (IObjectReplica) data.get(0);
	}
	
	@Override
	protected PayloadType tellType( Object payload ) {
		if ( payload instanceof IObjectReplica ) {
			return PayloadType.PAYLOAD_TYPE_OBJECT_REF;
		} else {
			return super.tellType( payload );
		}
	}
}
