package cz.cuni.amis.pogamut.emohawk.communication.stream;

import java.util.LinkedList;


/** Object stream buffer
 * 
 * Adds object buffering.
 * 
 * @author Paletz
 */
public class EncodedObjectStreamBuffer extends StreamBuffer implements IEncodedObjectInputStream {
	
	/** Clone
	 */
	@Override
	public EncodedObjectStreamBuffer clone() {
		EncodedObjectStreamBuffer retval = new EncodedObjectStreamBuffer();
		retval.data = new LinkedList<Object>( data );
		return retval;
	}
	
	/** Write object reference
	 */
	public void writeObjectRef( int ref ) {
		data.add( new EncodedObjectRef( ref ) );
	}
	
	@Override
	public int readObjectRef() {
		return ((EncodedObjectRef) data.pop()).getValue();
	}
	
	@Override
	public int peekObjectRef() {
		return ((EncodedObjectRef) data.getFirst()).getValue();
	}
	
	@Override
	protected PayloadType tellType( Object payload ) {
		if ( payload instanceof EncodedObjectRef ) {
			return PayloadType.PAYLOAD_TYPE_OBJECT_REF;
		} else {
			return super.tellType( payload );
		}
	}


}
