package cz.cuni.amis.pogamut.emohawk.communication.messages.stream;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IEncodedObjectInputStream;


/** Message with a stream of primitives payload
 * 
 * @author Paletz
 */
public interface IStreamPayloadCarrierInfoMessage {
	
	/** Get the stream payload
	 * 
	 * Does not mutate the message and its payload. 
	 */
	IEncodedObjectInputStream getPayloadStream();
	
	/** Add primitive to the payload
	 * 
	 * Construction method.
	 * 
	 * @param primitive primitive to add, must be boolean, integer, float, string, encoded object ref
	 * @param index
	 */
	void addPrimitive( Object primitive, int index );
}
