package cz.cuni.amis.pogamut.emohawk.communication.messages.stream;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.emohawk.communication.stream.StreamBuffer;


/** Command stream payload
 * 
 * @author Paletz
 */
public class CommandStreamPayload implements IStreamPayloadCarrierCommand {
	
	protected StreamBuffer payload;
	
	public CommandStreamPayload() {
		payload = new StreamBuffer();
	}
	
	public String toParameterText() {
		StreamBuffer payloadClone = payload.clone();
		StringBuffer retval = new StringBuffer();
		
		for ( int i=0; payloadClone.tellNext() != PayloadType.PAYLOAD_TYPE_EOF; ++i ) {

			retval.append( " " );
			
			switch ( payloadClone.tellNext() ) {
			case PAYLOAD_TYPE_BOOL:
				retval.append( "{BPKT"+i+" "+payloadClone.readBool()+"}" );
				break;
			case PAYLOAD_TYPE_FLOAT:
				retval.append( "{FPKT"+i+" "+payloadClone.readFloat()+"}" );
				break;
			case PAYLOAD_TYPE_INT:
				retval.append( "{IPKT"+i+" "+payloadClone.readInt()+"}" );
				break;
			case PAYLOAD_TYPE_STRING:
				retval.append( "{SPKT"+i+" "+payloadClone.readString()+"}" );
				break;
			default:
				throw new AssertionError();
			}
		}
		return retval.toString();
	}
	
	@Override
	public CommandStreamPayload clone() {
		CommandStreamPayload retval = new CommandStreamPayload();
		retval.payload = payload.clone();
		return retval;
	}

	@Override
	public void writeInt(int value) {
		payload.writeInt(value);
	}

	@Override
	public void writeFloat(float value) {
		payload.writeFloat(value);
	}

	@Override
	public void writeBool(boolean value) {
		payload.writeBool(value);
	}

	@Override
	public void writeString(String value) {
		payload.writeString(value);
	}

	@Override
	public IInputStream getPayload() {
		return payload.clone();
	}
}