package cz.cuni.amis.pogamut.emohawk.communication.messages.replication;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;

/** Replication batch wholy transmitted and may be committed
 * 
 * For batch oriented communication (i.e. BeginMessage and EndMessage) this event is replaced by EndMessage. 
 * 
 * @author Paletz
 */
public class ReplicationCommit extends InfoMessage implements IReplicationEvent {

	protected long simTime;
		
	public ReplicationCommit() {
		simTime = 0;
	}
	
	public ReplicationCommit( long simTime ) {
		this.simTime = simTime;
	}	

	
	/** Get simTime
	 * 
	 * @return simTime
	 */
	public long getSimTime() {
		return simTime;
	}

	/** Initialization from yylex
	 */
	protected void setSimTime( long value ) {
		simTime = value;
	}
}