package cz.cuni.amis.pogamut.emohawk.communication.messages.replication;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.IStreamPayloadCarrierInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.InfoMessageStreamPayload;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IEncodedObjectInputStream;

/** Object has been updated
 * 
 * Value is transmited by primitive data stream prior to this event.
 * @author Paletz
 */
public class ObjectUpdate extends InfoMessage implements IReplicationEvent, IStreamPayloadCarrierInfoMessage {

	protected long simTime;
	protected int replicationIndex;
	protected InfoMessageStreamPayload streamPayload;
		
	public ObjectUpdate() {
		simTime = 0;
		streamPayload = new InfoMessageStreamPayload();
	}	
	
	/** Get simTime
	 * 
	 * @return simTime
	 */
	public long getSimTime() {
		return simTime;
	}

	/** Get the replication index
	 * 
	 * @return the replication index	 
	 */
	public int getReplicationIndex() {
		return replicationIndex;
	}
	
	/** Initialization from yylex
	 */
	protected void setSimTime( long value ) {
		simTime = value;
	}
	
	/** Initialization from yylex
	 */
	public void setReplicationIndex(int replicationIndex) {
		this.replicationIndex = replicationIndex;
	}
	
	@Override
	public IEncodedObjectInputStream getPayloadStream() {
		return streamPayload.getPayloadStream();
	}

	@Override
	public void addPrimitive(Object primitive, int index) {
		streamPayload.addPrimitive( primitive, index );
	}
}
