package cz.cuni.amis.pogamut.emohawk.communication.messages.action;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.CommandStreamPayload;
import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.IStreamPayloadCarrierCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IInputStream;


/** Command to perform action
 * 
 * Action parameters can be stored in the embedded primitive data stream. 
 * Check documentation of the particular action in question.
 * 
 * @author Paletz
 */
public class PerformAction extends CommandMessage implements IStreamPayloadCarrierCommand {
	
	protected int performerIndex;
	protected int actionIndex;
	protected int userRequestId;
	protected CommandStreamPayload streamPayload;

	public PerformAction( 
    	int performerIndex,
    	int actionIndex,
    	int userRequestId
    ) {
        this.performerIndex = performerIndex;
        this.actionIndex = actionIndex;
        this.userRequestId = userRequestId;
        streamPayload = new CommandStreamPayload();
    }
	
	public PerformAction() {
		this( -1, -1, -1 );
    }
	
	public PerformAction( PerformAction original ) {
		this( original.performerIndex, original.actionIndex, original.userRequestId );
		this.streamPayload = original.streamPayload.clone();
    }
		
    @Override
	public void writeInt(int value) {
		streamPayload.writeInt(value);
	}

    @Override
	public void writeFloat(float value) {
		streamPayload.writeFloat(value);
	}

    @Override
	public void writeBool(boolean value) {
		streamPayload.writeBool(value);
	}

    @Override
	public void writeString(String value) {
		streamPayload.writeString(value);
	}
    
	@Override
	public IInputStream getPayload() {
		return streamPayload.getPayload();
	}

	/** Convert to string
	 * 
	 * @return string representation that can be sent to gamebots
	 */
	@Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append( "SACRQ " );
        builder.append( "{Performer "+performerIndex+"} " );
        builder.append( "{Action "+actionIndex+"} " );
        builder.append( "{UserRequestId "+userRequestId+"}" );
        builder.append( streamPayload.toParameterText() );
        return builder.toString();
    }

 }
