package cz.cuni.amis.pogamut.emohawk.communication;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.emohawk.agent.action.MajorActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.messages.action.ActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectReplication;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectTearOff;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectUpdate;
import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.IStreamPayloadCarrierInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.EncodedObjectRef;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Yylex;

/** Emohawk yylex
 * 
 * Extends UT2004 yylex with emohawk messages and commands.
 * @author Paletz
 */
public class EmohawkYylex extends Yylex {
	
	protected static final Pattern PRIMITIVE_STREAM_PARAMETER_PATTERN = Pattern.compile( "([IBFSR]PKT)([0-9]+)" );
	
	@Override 
	protected InfoMessage tryParsingUnprocessedMessage(String messageName) {
		if ( messageName.equals("ROB") ) {
			return new ObjectReplication();
		} else if ( messageName.equals("TOB") ) {
			return new ObjectTearOff();
		} else if ( messageName.equals("UOB") ) {
			return new ObjectUpdate();
		} else if ( messageName.equals("ACTRSLT") ) {
			return new ActionResult();
		} else {
			return super.tryParsingUnprocessedMessage(messageName);
		}
	}
	
	@Override
	protected boolean tryParsingUnprocessedMessageParameter(String paramName, String wholeParamText) {
		if ( actObj instanceof ObjectReplication ) {
			if ( paramName.equals("Index") ) {
				((ObjectReplication) actObj).setReplicationIndex( integerValue( wholeParamText ) );
				return true;
			} else if ( paramName.equals("Class") ) {
				((ObjectReplication) actObj).setObjectClass( stringValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof ObjectTearOff ) {
			if ( paramName.equals("Index") ) {
				((ObjectTearOff) actObj).setReplicationIndex( integerValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof ObjectUpdate ) {
			if ( paramName.equals("Index") ) {
				((ObjectUpdate) actObj).setReplicationIndex( integerValue( wholeParamText ) );
				return true;
			} 
			return tryParsingUnprocessedMessageStreamPrimitive( paramName, wholeParamText );
		} else if ( actObj instanceof ActionResult ) {
			if ( paramName.equals("Message") ) {
				((ActionResult) actObj).setMessage( stringValue( wholeParamText ) );
				return true;
			} else if ( paramName.equals("Major") ) {
				((ActionResult) actObj).setMajor( MajorActionResult.values()[integerValue( wholeParamText )] );
				return true;
			} else if ( paramName.equals("Minor") ) {
				((ActionResult) actObj).setMinor( integerValue( wholeParamText ) );
				return true;
			} else if ( paramName.equals("UsrRqId") ) {
				((ActionResult) actObj).setUserRequestId( integerValue( wholeParamText ) );
				return true;
			}
			return tryParsingUnprocessedMessageStreamPrimitive( paramName, wholeParamText );
		} else {
			return super.tryParsingUnprocessedMessageParameter(paramName, wholeParamText);
		}
	}
	
	 
	protected boolean tryParsingUnprocessedMessageStreamPrimitive( String paramName, String wholeParamText ) {
		Matcher primitiveParameterNameMatcher = PRIMITIVE_STREAM_PARAMETER_PATTERN.matcher(paramName);
		if ( !primitiveParameterNameMatcher.matches() ) {
			return false;
		}
		
		String label = primitiveParameterNameMatcher.group( 1 );
		int index = Integer.parseInt( primitiveParameterNameMatcher.group( 2 ) );
		IStreamPayloadCarrierInfoMessage embeddedPrimitiveStreamMessage = ((IStreamPayloadCarrierInfoMessage)actObj);
		
		if ( label.equals( "IPKT" ) ) {
			embeddedPrimitiveStreamMessage.addPrimitive( integerValue(wholeParamText), index );
			return true;
		} else if ( label.equals( "BPKT" ) ) {
			embeddedPrimitiveStreamMessage.addPrimitive( booleanValue(wholeParamText), index );
			return true;
		} else if ( label.equals( "FPKT" ) ) {
			embeddedPrimitiveStreamMessage.addPrimitive( floatValue(wholeParamText), index );
			return true;
		} else if ( label.equals( "SPKT" ) ) {
			embeddedPrimitiveStreamMessage.addPrimitive( stringValue(wholeParamText), index );
			return true;
		} else if ( label.equals( "RPKT" ) ) {
			embeddedPrimitiveStreamMessage.addPrimitive( new EncodedObjectRef( intValue(wholeParamText) ), index );
			return true;
		} else {
			throw new AssertionError( "Primitive stream parameter pattern shouldn't have matched the param name." );
		}
	}
}
