package cz.cuni.amis.pogamut.emohawk.bot.impl;

import java.util.Random;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.EhAgentInfo;
import cz.cuni.amis.pogamut.emohawk.agent.action.Activeness;
import cz.cuni.amis.pogamut.emohawk.agent.game.EhGame;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.navigation.EmohawkNavigation;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IPureHistoricWorldView;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.Communication;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Trace;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TraceResponse;

/** Top-level bot inteligence
 * 
 * @author Paletz
 */
public class EmohawkBotBrain {
	
	private EmohawkBotController<?> controller;
	
	public EmohawkBotBrain( EmohawkBotController<?> controller ) {
		this.controller = controller;
	}
	
	
	// MODULES

	
	public Random getRandom() {
		return controller.getRandom();
	}
	
	/** Get module specialized on general info about the agent whereabouts.
	 * 
	 * @deprecated functionality moved to emohawk agent info
	 */
	@Deprecated
	public UT2004AgentInfo getUtAgentInfo() {
		return controller.getUtAgentInfo();
	}
	
	/** Get agent info module
	 * <p>
	 * Provides access to bot's pawn etc.
	 * </p>
	 */
	public EhAgentInfo getAgentInfo() {
		return controller.getAgentInfo();
	}
	
	/** Get memory module specialized on the agent's configuration inside <strike>UT2004</strike> Emohawk - name, vision time, manual spawn, cheats (if enabled at GB2004).
	 *
	 * @deprecated Not tested in context of Emohawk, expect bugs.
	 */
	@Deprecated
	public AgentConfig getConfig() {
		return controller.getConfig();
	}

	/** Get support for creating rays used for raycasting (see {@link AutoTraceRay} that is being utilized).
	 * <p>
	 * WARNING: As of January 2014 the GameBotsUDK raytracing is only partially tested.
	 * Tested parts ({@link Trace} and {@link TraceResponse}) were incredibly buggy (now fixed).
	 * Raycasting uses untested parts :(
	 * </p> 
	 */
	public Raycasting getRaycasting() {
		return controller.getRaycasting();
	}

	/** Get movement module.
	 */
	public AdvancedLocomotion getMovement() {
		return controller.getMovement();
	}
	
	/** Get memory module specialized on general info about the ut2004game - ut2004game type, time limit, frag limit, etc.
	 * 
	 * @deprecated functionality moved to emohawk {@link #game}
	 */
	@Deprecated
	public Game getUtGame() {
		return controller.getUtGame();
	}
	
	/** Get game rules and state module
	 */
	public EhGame getGame() {
		return controller.getGame();
	}
	
	/** Get communication module
	 * <p>
	 * Allows for speaking and listening.
	 * </p>
	 */
	public Communication getComm() {
		return controller.getComm();
	}
	
	/** Get navigation graph builder
	 * <p>
	 * Allows for modification of navigation graph exported from the game.
	 * </p> 
	 */
	public NavigationGraphBuilder getNavGraphBuilder() {
		return controller.getNavGraphBuilder();
	}
	
	/** Get path executor
	 * <p>
	 * Path executor is used for following a path in the environment.
	 * </p>
     */
	public IUnrealPathExecutor<ILocated> getPathExecutor() {
		return controller.getPathExecutor();
	}

    /** Get path planner.
     * <p>
     * Path planner used to compute the path (consisting of navigation points) inside the map.
     * </p>
     */
	public IPathPlanner<ILocated> getPathPlanner() {
		return controller.getPathPlanner();
	}

    /** Get navigation graph builder
     * <p>
     * Navigation graph builder may be used to modify the navigation graph exported from the map (level).
     * </p>
     */
	public IPureHistoricWorldView getWorldView() {
		return controller.getWorldView();
	}
	
    /** Get Floyd-Warshall map
     * <p>
     * Floyd-Warshall map of the navigation graph; can be used to find shortest path between navigation points.
     * </p>
     * @see {@link EmohawkNavigation#getNearestNavPoint(ILocated)}
     */
	public FloydWarshallMap getFwMap() {
		return controller.getFwMap();
	}
	
    /** Get navigation module
     * <p> 
     * Navigation module can be used for bot navigation within the environment.
     * </p> 
     */
	public EmohawkNavigation getNavigation() {
		return controller.getNavigation();
	}
	
	/** Get act module
	 * <p>
	 * Low level command issuing interface.
	 * </p>
	 */
	public IAct getAct() {
		return controller.getAct();
	}
	
	/** Get Action performing module
	 * <p>
	 * Allows the bot to request an action to be performed.
	 * </p>
	 */
	public Activeness getActiveness() {
		return controller.getActiveness();
	}
	
	
	// CALLBACKS
	
	
	/** Get password used to authenticate to UDK server
	 */
	public String getPassword() {
		return "unspecified";
	}
    
	/** Get initialization command to send to UDK server
	 */
	public Initialize getInitializeCommand() {
		return new Initialize();
	}
	
	/** Called when bot has been initialized
	 */
	public void botInitialized() {
	}
    
	/** Called when bot has spawned for the first time
	 */
	public void botFirstSpawn() {
	}
        
	/** Called when bot has been killed
	 */
	public void botKilled(BotKilled event) {		
	}

	/** Called when bot is shutting down
	 */
	public void botShutdown() {
	}
	
	/** Called before first logic() tick
	 */
	public void beforeFirstLogic() {
	}

	/** Logic tick
	 * 
	 * Opportunity to inspect environment and make decisions.
	 */
	public void logic() {
	}
	
	
}
