/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.messages.stream;

import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.IStreamPayloadCarrierCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.emohawk.communication.stream.StreamBuffer;

public class CommandStreamPayload
implements IStreamPayloadCarrierCommand {
    protected StreamBuffer payload = new StreamBuffer();

    public String toParameterText() {
        StreamBuffer payloadClone = this.payload.clone();
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (payloadClone.tellNext() != PayloadType.PAYLOAD_TYPE_EOF) {
            retval.append(" ");
            switch (payloadClone.tellNext()) {
                case PAYLOAD_TYPE_BOOL: {
                    retval.append("{BPKT" + i + " " + payloadClone.readBool() + "}");
                    break;
                }
                case PAYLOAD_TYPE_FLOAT: {
                    retval.append("{FPKT" + i + " " + payloadClone.readFloat() + "}");
                    break;
                }
                case PAYLOAD_TYPE_INT: {
                    retval.append("{IPKT" + i + " " + payloadClone.readInt() + "}");
                    break;
                }
                case PAYLOAD_TYPE_STRING: {
                    retval.append("{SPKT" + i + " " + payloadClone.readString() + "}");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++i;
        }
        return retval.toString();
    }

    public CommandStreamPayload clone() {
        CommandStreamPayload retval = new CommandStreamPayload();
        retval.payload = this.payload.clone();
        return retval;
    }

    @Override
    public void writeInt(int value) {
        this.payload.writeInt(value);
    }

    @Override
    public void writeFloat(float value) {
        this.payload.writeFloat(value);
    }

    @Override
    public void writeBool(boolean value) {
        this.payload.writeBool(value);
    }

    @Override
    public void writeString(String value) {
        this.payload.writeString(value);
    }

    @Override
    public IInputStream getPayload() {
        return this.payload.clone();
    }
}

