/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.emoticon;

import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.emoticon.EmoticonBubbleType;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.emoticon.EmoticonType;

public class Emoticon {
    private static EmoticonBubbleType DEFAULT_BUBBLE = EmoticonBubbleType.BUBBLE_THOUGHT_CENTER;
    private EmoticonType leftEmoticon;
    private EmoticonType centerEmoticon;
    private EmoticonType rightEmoticon;
    private EmoticonBubbleType bubble;
    private int emoticonCount = 0;

    public EmoticonBubbleType getBubble() {
        return this.bubble;
    }

    public EmoticonType getCenterEmoticon() {
        return this.centerEmoticon;
    }

    public EmoticonType getLeftEmoticon() {
        return this.leftEmoticon;
    }

    public EmoticonType getRightEmoticon() {
        return this.rightEmoticon;
    }

    public int getEmoticonCount() {
        return this.emoticonCount;
    }

    public EmoticonType[] getEmoticonTypes() {
        switch (this.getEmoticonCount()) {
            case 0: {
                return new EmoticonType[0];
            }
            case 1: {
                return new EmoticonType[]{this.getCenterEmoticon()};
            }
            case 2: {
                return new EmoticonType[]{this.getLeftEmoticon(), this.getRightEmoticon()};
            }
            case 3: {
                return new EmoticonType[]{this.getLeftEmoticon(), this.getCenterEmoticon(), this.getRightEmoticon()};
            }
        }
        throw new RuntimeException("Emoticon returned wrong emoticon count = " + this.getEmoticonCount() + " !!!");
    }

    public Emoticon(EmoticonType leftEmoticon, EmoticonType centerEmoticon, EmoticonType rightEmoticon, EmoticonBubbleType bubble) {
        this.leftEmoticon = leftEmoticon;
        this.centerEmoticon = centerEmoticon;
        this.rightEmoticon = rightEmoticon;
        if (leftEmoticon != null && rightEmoticon != null && centerEmoticon != null && leftEmoticon != EmoticonType.NONE && rightEmoticon != EmoticonType.NONE && centerEmoticon != EmoticonType.NONE) {
            this.emoticonCount = 3;
        } else if (leftEmoticon != null && rightEmoticon != null && leftEmoticon != EmoticonType.NONE && rightEmoticon != EmoticonType.NONE) {
            this.emoticonCount = 2;
        } else if (centerEmoticon != null && centerEmoticon != EmoticonType.NONE) {
            this.emoticonCount = 1;
        }
        this.bubble = bubble;
        if (bubble == null || bubble == EmoticonBubbleType.NONE) {
            bubble = DEFAULT_BUBBLE;
        }
    }

    public Emoticon(EmoticonType centerEmoticon, EmoticonBubbleType bubble) {
        this.centerEmoticon = centerEmoticon;
        if (centerEmoticon != null && centerEmoticon != EmoticonType.NONE) {
            this.emoticonCount = 1;
        }
        this.bubble = bubble;
        if (bubble == null || bubble == EmoticonBubbleType.NONE) {
            bubble = DEFAULT_BUBBLE;
        }
    }

    public Emoticon(EmoticonType leftEmoticon, EmoticonType rightEmoticon, EmoticonBubbleType bubble) {
        this.leftEmoticon = leftEmoticon;
        this.rightEmoticon = rightEmoticon;
        if (leftEmoticon != null && rightEmoticon != null && leftEmoticon != EmoticonType.NONE && rightEmoticon != EmoticonType.NONE) {
            this.emoticonCount = 2;
        }
        this.bubble = bubble;
        if (bubble == null || bubble == EmoticonBubbleType.NONE) {
            bubble = DEFAULT_BUBBLE;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Emoticon other = (Emoticon)obj;
        if (this.leftEmoticon != other.leftEmoticon) {
            return false;
        }
        if (this.centerEmoticon != other.centerEmoticon) {
            return false;
        }
        if (this.rightEmoticon != other.rightEmoticon) {
            return false;
        }
        if (this.bubble != other.bubble) {
            return false;
        }
        return this.emoticonCount == other.emoticonCount;
    }

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + (this.leftEmoticon != null ? this.leftEmoticon.hashCode() : 0);
        hash = 11 * hash + (this.centerEmoticon != null ? this.centerEmoticon.hashCode() : 0);
        hash = 11 * hash + (this.rightEmoticon != null ? this.rightEmoticon.hashCode() : 0);
        hash = 11 * hash + (this.bubble != null ? this.bubble.hashCode() : 0);
        hash = 11 * hash + this.emoticonCount;
        return hash;
    }

    public String toString() {
        return "Emoticon[left=" + (Object)((Object)this.leftEmoticon) + ", center=" + (Object)((Object)this.centerEmoticon) + ", right=" + (Object)((Object)this.rightEmoticon) + ", bubble=" + (Object)((Object)this.bubble) + "]";
    }
}

