package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.worldObject;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.worldObject.ISituated;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractObjectReplica;

/** Replica of a world object situation
 * 
 * Equivalent of UDK EhActorSituation.
 * 
 * @author Paletz
 */
public class SituationReplica extends AbstractObjectReplica implements ISituated {

	protected Location location;
	protected Rotation rotation;
	protected Velocity velocity;
	
	@Override
	public Location getLocation() {
		return location;
	}

	@Override
	public Rotation getRotation() {
		return rotation;
	}

	@Override
	public Velocity getVelocity() {
		return velocity;
	}
	
	@Override
	public void receive(IObjectInputStream stream) {
		if ( stream.readBool() ) // isDefined
		{
			location = SerializationTools.deserializeLocation( stream );
			rotation = SerializationTools.deserializeRotation( stream );
			velocity = SerializationTools.deserializeVelocity( stream );
			assert( location != null && rotation != null && velocity != null );
		}
		else
		{
			location = null;
			rotation = null;
			velocity = null;
		}
	}
}
