package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PrimitiveTools;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Boxed primitive type
*
* Supports reference types too.
*/
public class PrimitiveBoxReplica<Primitive> extends AbstractGenericObjectReplica {

	protected Primitive value;
	
	public PrimitiveBoxReplica() {
		super(1);
	}
	
	/** Constructor
	 * 
	 * @param valueClass value type parameter
	 * @param value value
	 */
	public PrimitiveBoxReplica( Class<Primitive> valueClass, Primitive value ) {
		super(1);
		setTypeParameter( 0, SpecializedClass.fromPlain( valueClass ) );
		this.value = value;
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	public SpecializedClass<Primitive> getValueClass() {
		@SuppressWarnings({ "unchecked" })
		SpecializedClass<Primitive> retval = (SpecializedClass<Primitive>) typeParameters[0];
		return retval;
	}
	
	/** Get boxed value
	 *
	 * @return boxed value
	 */
	public Primitive get() {
		return value;
	}
	
	@Override
	public void receive( IObjectInputStream inputStream )
	{
		value = PrimitiveTools.readPrimitive( getValueClass().getGenericClass(), inputStream );
	}
}