package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** A foggy reference
 * 
 * @see IFoggyReference
 * @author Paletz
 */
public class FoggyReferenceReplica
	<TReplicaReference extends IObjectReplica>
	extends AbstractGenericObjectReplica
	implements IFoggyReference<TReplicaReference> {
	
	protected int referenceIndex;
	
	public FoggyReferenceReplica() {
		super(1);
	}
		
	/** Get replica reference type parameter class
	 * 
	 * @return replica reference type parameter class
	 */
	public SpecializedClass<TReplicaReference> getReplicaReferenceClass() {
		@SuppressWarnings("unchecked")
		SpecializedClass<TReplicaReference> retval = (SpecializedClass<TReplicaReference>) typeParameters[0];
		return retval;
	}
	
	@Override
	public TReplicaReference getNotHidden()	{
		if ( referenceIndex == -1 ) {
			return null;
		} else {
			assert( objectReplicationClient.exists( referenceIndex ) );
			@SuppressWarnings("unchecked")
			TReplicaReference retval = (TReplicaReference) objectReplicationClient.getObject( referenceIndex );
			assert( retval == null || getReplicaReferenceClass().isInstance( retval ) );
			return retval;
		}
	}
	
	@Override
	public TReplicaReference getHiddenAsNull() {
		if ( referenceIndex == -1 || !objectReplicationClient.exists( referenceIndex ) ) {
			return null;
		} else {
			@SuppressWarnings("unchecked")
			TReplicaReference retval = (TReplicaReference) objectReplicationClient.getObject( referenceIndex );
			assert( retval == null || getReplicaReferenceClass().isInstance( retval ) );
			return retval;
		}
	}

	@Override
	public boolean isHidden()
	{
		return referenceIndex != -1 && !objectReplicationClient.exists( referenceIndex );
	}
	

	@Override
	public boolean isSet() {
		return isHidden() || getNotHidden() != null;
	}
	
	@Override
	public void receive( IObjectInputStream stream ) {
		referenceIndex = stream.readInt();
	}
}
