package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.primitiveList;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.sll.SinglyLinkedListReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** List attribute view
 *  
 * Filters attribute not matching given list type.
 */
public class ListAttributeView<T> implements IListAttributeView<T> {
	
	protected AttributeRawView<ListAttributeReplica<T>> rawView;
	protected SpecializedClass<T> primitiveClass;
	
	public ListAttributeView( 
		SpecializedClass<T> primitiveClass, 
		Map<String,IAttributeReplica> attributes
	) {
		this.primitiveClass = primitiveClass;
		
		@SuppressWarnings({ "unchecked", "rawtypes" })
		Class<ListAttributeReplica<T>> attributeClass = (Class) ListAttributeReplica.class; // java is really dumb here
		
		rawView = new AttributeRawView<ListAttributeReplica<T>>( 
			attributes,
			new SpecializedClass<ListAttributeReplica<T>>(
				attributeClass, 
				Arrays.asList( new SpecializedClass<?>[] { primitiveClass } )
			)
		);
	}
	
	@Override
	public Collection<T> read( String attributeName ) {
		ListAttributeReplica<T> attribute = rawView.getAttributeRecord( attributeName );
		SinglyLinkedListReplica<T> retval = (SinglyLinkedListReplica<T>) attribute.getValue();
		assert( primitiveClass.equals( retval.getValueClass() ) );
		return retval;
	}
	
	@Override
	public boolean exists( String attributeName ) {
		return rawView.exists( attributeName );
	}
	
	@Override
	public Iterator<Entry<String,ListAttributeReplica<T>>> iterator() {
		return rawView.iterator();
	}
}
