package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;

/** Abstract attribute view
 * 
 * Provides a set of low level operations with type-filtering logic.
 * 
 * @author Paletz
 */
public class AttributeRawView<Attribute> {

	protected SpecializedClass<Attribute> attributeClass;
	protected Map<String,IAttributeReplica> attributes;
	
	/** Constructor
	 */
	public AttributeRawView(
		Map<String,IAttributeReplica> attributes,
		SpecializedClass<Attribute> attributeClass
	) {
		this.attributes = attributes;
		this.attributeClass = attributeClass;
	}
	
	/** Get attributes
	 */
	public Map<String,IAttributeReplica> getAttributes() {
		return attributes;
	}
	
	/** Get attribute record
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute record
	 */
	public Attribute getAttributeRecord( String attributeName ) {
		@SuppressWarnings("unchecked")
		Attribute attribute = (Attribute) attributes.get( attributeName );
		assert( attributeClass.isInstance( attribute ) );
		
		return attribute;
	}
	
	/** Tell if attribute exists and has the right type
	 *
	 * @param attributeName attribute name
	 * @param access required access
	 * @return true if attribute exists and has the right type and access, false otherwise
	 */
	public boolean exists( String attributeName )
	{
		if ( attributes.containsKey( attributeName ) ) {
			IAttributeReplica attribute = attributes.get( attributeName );
			return attributeClass.isInstance( attribute );
		} else {
			return false;
		}
	}
	
	/** Iterate over attributes in view
	 * 
	 * @return view iterator
	 */
	public Iterator<Entry<String,Attribute>> iterator() {
		final Iterator<Entry<String,IAttributeReplica>> iterator = attributes.entrySet().iterator();
		
		return new Iterator<Entry<String,Attribute>>() {
			
			Entry<String,Attribute> next;
			
			@Override
			public boolean hasNext() {
				fetchNext();
				return next != null; // attribute can't be null
			}
			
			@Override
			public Entry<String,Attribute> next() {
				fetchNext();
				assert( next != null ); // attribute can't be null
				return next;
			}
			
			@Override
			public void remove() {
				throw new UnsupportedOperationException( "Can't remove attribute." );
			}
			
			protected void fetchNext() {
				if ( next != null ) {
					return;
				}
				
				while ( iterator.hasNext() ) {
					final Entry<String,IAttributeReplica> candidate = iterator.next();
					if ( attributeClass.isInstance( candidate.getValue() ) ) {
						@SuppressWarnings("unchecked")
						Entry<String,Attribute> newNext = new ListMapEntryReplica<String,Attribute>( candidate.getKey(), (Attribute) candidate.getValue() );
						next = newNext;
						break;
					}
				}
			}
		};
	}
}