package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.IReplicationEvent;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ReplicationCommit;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IWorldObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.IWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.IReplicaEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaCreatedEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaTornOffEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.utils.listener.IListener;

public class ReplicationWorldObjectUpdater implements IWorldObjectUpdater {
	
	protected ISimulationClock simulationClock;
	protected IObjectReplicationClient objectReplicationClient;
	protected IWorldObjectRegistry worldObjectRegistry;
	
	@Inject
	public ReplicationWorldObjectUpdater(
		IObjectReplicationClient objectReplicationClient
	) {
		super();
		this.objectReplicationClient = objectReplicationClient;
		objectReplicationClient.registerReplicaEventListener( replicaEventListener );
	}
	
	@Override
	public void applyWorldObjectUpdate(IWorldChangeEvent event) {
		
		if ( event instanceof EndMessage ) {
			objectReplicationClient.applyReplicationEvent( new ReplicationCommit( event.getSimTime() ) );
		}
		
		if ( event instanceof IReplicationEvent ) {
			objectReplicationClient.applyReplicationEvent( (IReplicationEvent) event );
		}
		
		if ( event instanceof BeginMessage || event instanceof EndMessage ) {
			simulationClock.applyWorldChange( event );
		}
	}
	
	@Override
	public void initWorldObjectRegistry(IWorldObjectRegistry worldObjectRegistry) {
		this.worldObjectRegistry = worldObjectRegistry;
	}
	
	@Override
	public void initSimulationClock( ISimulationClock simulationClock ) {
		this.simulationClock = simulationClock;
		objectReplicationClient.initSimulationClock( simulationClock );
	}
	
	protected final IListener<IReplicaEvent> replicaEventListener = new IListener<IReplicaEvent>() {
		@Override
		public void notify(IReplicaEvent event) {
			if ( event.getReplica() instanceof IWorldObject ) {
				IWorldObject worldObject = (IWorldObject) event.getReplica();
				if ( event instanceof ReplicaCreatedEvent ) {
					worldObjectRegistry.registerObject( worldObject, simulationClock.getTime() );
				} else if ( event instanceof ReplicaUpdatedEvent ) {
					worldObjectRegistry.notifyObjectUpdated( worldObject, simulationClock.getTime() );
				} else if ( event instanceof ReplicaTornOffEvent ) {
					worldObjectRegistry.forgetObject( worldObject, simulationClock.getTime() );
				} else {
					throw new AssertionError( "Unexpected event." );
				}
			}
		}
	};
}
