package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.player;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.SightingMemory.BeliefSupport;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.pawn.IPawnBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.player.IPlayerBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.ds.FoggyReferenceBeliefSubrecord;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.worldObject.AbstractViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.pawn.IPawnMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.player.IPlayerMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.player.PlayerMemorization;

/** Player soul belief
 * 
 * Equivalent of UDK EhController.
 * 
 * @author Paletz
 */

public class PlayerBelief extends AbstractViewableObjectBelief  {

	protected FoggyReferenceBeliefSubrecord<IPawnMemorization, IPawnBelief> primaryPawn;
	
	/** Constructor
	 */
	public PlayerBelief( PlayerMemorization memorization, BeliefSupport beliefSupport ) {
		super(memorization, beliefSupport );
		primaryPawn = new FoggyReferenceBeliefSubrecord<IPawnMemorization, IPawnBelief>( beliefSupport, IPawnMemorization.class, IPawnBelief.class );
		updatePrimaryPawn();
	}
	
	@Override
	public void updateMemorization( IObjectMemorization newMemorization ) {
		assert( newMemorization instanceof PlayerMemorization );
		super.updateMemorization( newMemorization );
		updatePrimaryPawn();
	}
	
	@Override
	public IPlayerBelief getImmutableFacade() {
		return (IPlayerBelief) immutableFacade;
	}

	@Override
	protected PlayerBeliefImmutableFacade makeImmutableFacade() {
		return new PlayerBeliefImmutableFacade();
	}
	
	protected PlayerMemorization getMemorizationImpl() {
		return (PlayerMemorization) memorization;
	}
	
	protected void updatePrimaryPawn() {
		primaryPawn.updateMemorization( getMemorizationImpl().getPrimaryPawn() );
	}
	
	public class PlayerBeliefImmutableFacade extends AbstractViewableObjectBeliefImmutableFacade implements IPlayerBelief {
		
		@Override
		public IPlayerMemorization getMemorization() {
			return getMemorizationImpl();
		}

		@Override
		public boolean isSelf() {
			return getMemorization().isSelf();
		}

		@Override
		public IFoggyReference<? extends IPawnBelief> getPrimaryPawn() {
			return primaryPawn.getImmutableFacade();
		}

	}
}
