package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.object;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.IPureHistoricWorldView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;

/** Belief of an object
 * 
 * The latest memorization (observed state) of an object.
 * When a belief references other belief both must be the latest memorization of the respective object and thus may come from mismatching points in time.
 * In this sense the belief is ignorant - it may disregard observations from matching time in favor of more recent observations.
 * 
 * @author Paletz
 */
public interface IObjectBelief {
	
	/** Get the most recent memorization of the object
	 * 
	 * @return the most recent memorization of the proxied world object
	 */
	IObjectMemorization getMemorization();
	
	/** Tell whether the belief is plausible.
	 * 
	 * Belief is plausible until contradicted by more recent observations, for example when item's remembered location has been observed empty.
	 * 
	 * @return true if the world object belief is plausible
	 * @see IPureHistoricWorldView#contradict(IWorldObjectBelief)
	 */
	boolean isPlausible();
}
