package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.IWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;


/** Historic world object updater
 * 
 * Historic object updater creates ignorant beliefs.
 * These beliefs automatically refer to the most recently observed object state ("memorization") and allow to it. 
 * 
 * @author Paletz
 */
public interface IHistoricWorldObjectUpdater extends IWorldObjectUpdater {
	
	/** Get duration of short term memory
	 * 
	 * Contradicted beliefs are retained at least for this duration. 
	 * 
	 * @return duration of short term memory in seconds
	 */
	double getShortTermMemoryDuration();
	
	/** Set duration of short term memory
	 * 
	 * Contradicted beliefs are retained at least for this duration. 
	 * 
	 * @param durationSeconds duration of short term memory
	 */
	void setShortTermMemoryDuration( double durationSeconds );
	
	/** Contradict a belief
	 * 
	 * Mark a belief contradicted.
	 * If belief already is contradicted, nothing happens.
	 * 
	 * @param belief belief to contradict, must not be visible
	 */
	void contradict( IViewableObjectBelief belief );
}
