package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;

/** World object belief registry implementation
 * 
 * @author Paletz
 */
public class ViewableObjectBeliefRegistry extends ViewableObjectRegistry implements IViewableObjectBeliefRegistry {

	/** Plausible world object belief listing
	 */
	protected ObjectListing<WorldObjectId, IViewableObjectBelief> plausibleBeliefListing;
	
	public ViewableObjectBeliefRegistry() {
		plausibleBeliefListing = new ObjectListing<WorldObjectId, IViewableObjectBelief>();
	}
	
	@Override
	public IObjectListing<WorldObjectId, IViewableObjectBelief> getPlausibleBeliefs() {
		return plausibleBeliefListing;
	}
	
	/** Clear all registries
	 */
	public void clear() {
		super.clear();
		plausibleBeliefListing.clear();
	}
	
	@Override
	public void registerObject( IWorldObject object, SimulationTime time ) {
		super.registerObject( object, time );
		
		if ( object instanceof IViewableObjectBelief ) {
			updateBeliefTracking( (IViewableObjectBelief) object );
		}
	}
	
	@Override
	public void notifyObjectUpdated( IWorldObject object, SimulationTime time ) {
		
		if ( object instanceof IViewableObjectBelief ) {
			updateBeliefTracking( (IViewableObjectBelief) object );
		}
		
		super.notifyObjectUpdated( object, time );
	}
	
	@Override
	public void forgetObject( IWorldObject object, SimulationTime time ) {
		
		if ( object instanceof IViewableObjectBelief ) {
			updateBeliefTracking( (IViewableObjectBelief) object );
		}
		
		super.forgetObject( object, time );
	}
	
	protected void updateBeliefTracking( IViewableObjectBelief object ) {
		
		boolean isTrackedPlausible = plausibleBeliefListing.getMap().containsKey( object.getId() );
		boolean isPlausible = object.isPlausible();
		
		if ( isPlausible && !isTrackedPlausible ) {
			plausibleBeliefListing.add( object.getId(), object );
			assert( worldObjectListing.getById( object.getId() ) != null );
		} else if ( !isPlausible && isTrackedPlausible ) {
			plausibleBeliefListing.remove( object.getId() );
		}		
	}
}
