package cz.cuni.amis.pogamut.emohawk.communication.stream;

/** Stream tools
 * 
 * @author Paletz
 */
public class StreamTools {

	/** Pipe stream
	 * 
	 * Sends currently available input to output
	 * 
	 * @param inputStream input stream
	 * @param outputStream output stream
	 */
	public static void pipeStream( IInputStream inputStream, IOutputStream outputStream )
	{
		while ( inputStream.tellNext() != PayloadType.PAYLOAD_TYPE_EOF )
		{
			pipePrimitive( inputStream, outputStream );
		}
	}
	
	/** Pipe stream
	 * 
	 * Sends currently available input to output
	 * 
	 * @param inputStream input stream
	 * @param outputStream output stream
	 */
	public static void pipeEncodedStream( IEncodedObjectInputStream inputStream, IEncodedObjectOutputStream outputStream )
	{
		while ( inputStream.tellNext() != PayloadType.PAYLOAD_TYPE_EOF )
		{
			pipeEncodedPrimitive( inputStream, outputStream );
		}
	}
	
	/** Pipe stream
	 * 
	 * Sends currently available input to output
	 * 
	 * @param inputStream input stream
	 * @param outputStream output stream
	 */
	public static void pipeObjectStream( IObjectInputStream inputStream, IObjectOutputStream outputStream )
	{
		while ( inputStream.tellNext() != PayloadType.PAYLOAD_TYPE_EOF )
		{
			pipeObjectPrimitive( inputStream, outputStream );
		}
	}
	
	
	/** Pipe one primitive
	 * 
	 * Pipes one primitive from input to output
	 * 
	 * @param inputStream input stream
	 * @param outputStream output stream
	 */
	public static void pipePrimitive( IInputStream inputStream, IOutputStream outputStream )
	{
		switch ( inputStream.tellNext() )
		{
		case PAYLOAD_TYPE_BOOL:
			outputStream.writeBool( inputStream.readBool() );
			break;
		case PAYLOAD_TYPE_INT:
			outputStream.writeInt( inputStream.readInt() );
			break;
		case PAYLOAD_TYPE_FLOAT:
			outputStream.writeFloat( inputStream.readFloat() );
			break;
		case PAYLOAD_TYPE_STRING:
			outputStream.writeString( inputStream.readString() );
			break;
		default:
			throw new RuntimeException( "Unexpected payload." );
		}
	}
	
	/** Pipe one primitive
	 * 
	 * Pipes one primitive from input to output
	 * 
	 * @param inputStream input stream
	 * @param outputStream output stream
	 */
	public static void pipeEncodedPrimitive( IEncodedObjectInputStream inputStream, IEncodedObjectOutputStream outputStream )
	{
		if ( inputStream.tellNext() == PayloadType.PAYLOAD_TYPE_OBJECT_REF )
		{
			outputStream.writeObjectRef( inputStream.readObjectRef() );
		}
		else
		{
			pipePrimitive( inputStream, outputStream );
		}
	}
	
	/** Pipe one primitive
	 * 
	 * Pipes one primitive from input to output
	 * 
	 * @param inputStream input stream
	 * @param outputStream output stream
	 */
	public static void pipeObjectPrimitive( IObjectInputStream inputStream, IObjectOutputStream outputStream )
	{
		if ( inputStream.tellNext() == PayloadType.PAYLOAD_TYPE_OBJECT_REF )
		{
			outputStream.writeObjectRef( inputStream.readObjectRef() );
		}
		else
		{
			pipePrimitive( inputStream, outputStream );
		}
	}
	}
